/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.jdbc.oracore.PickleContext;
import oracle.sql.ArrayDescriptor;
import oracle.sql.AttributeDescriptor;
import oracle.sql.Datum;
import oracle.sql.Kotad;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.SQLName;
import oracle.sql.StructDescriptor;

public class TypeDescriptor
implements Serializable,
ORAData {
    public static boolean DEBUG_SERIALIZATION = false;
    static final long serialVersionUID = 2022598722047823723L;
    static final int KOIDFLEN = 16;
    static final short KOTA_TRN = 1;
    static final short KOTA_PDF = 2;
    static final short KOTA_ITOID = 4;
    static final short KOTA_LOB = 8;
    static final short KOTA_AD = 16;
    static final short KOTA_NMHSH = 32;
    static final short KOTA_TEV = 64;
    static final short KOTA_INH = 128;
    static final short KOTA_10I = 256;
    static final short KOTA_RBF = 512;
    static final short KOTA_HBF = 1024;
    static final int ANYTYPE_IMAGE_SIZE_TOID = 23;
    static final int ANYTYPE_IMAGE_SIZE_NO_TOID = 5;
    static final byte KOTTDOID = 1;
    static final byte KOTTBOID = 2;
    static final byte KOTADOID = 3;
    static final byte KOTREFOID = 4;
    static final byte KOTMDOID = 5;
    static final byte KOTMIOID = 6;
    static final byte KOTEXOID = 7;
    static final byte KOTDATOID = 8;
    static final byte KOTBYTOID = 9;
    static final byte KOTSHOOID = 10;
    static final byte KOTLONOID = 11;
    static final byte KOTREAOID = 12;
    static final byte KOTDOUOID = 13;
    static final byte KOTFLOOID = 14;
    static final byte KOTNUMOID = 15;
    static final byte KOTDECOID = 16;
    static final byte KOTUBYOID = 17;
    static final byte KOTUSHOID = 18;
    static final byte KOTULOOID = 19;
    static final byte KOTOCTOID = 20;
    static final byte KOTSMLOID = 21;
    static final byte KOTINTOID = 22;
    static final byte KOTRAWOID = 23;
    static final byte KOTPTROID = 24;
    static final byte KOTVSIOID = 25;
    static final byte KOTFSIOID = 26;
    static final byte KOTVSOOID = 27;
    static final byte KOTMLSOID = 28;
    static final byte KOTVAROID = 29;
    static final byte KOTMSTOID = 30;
    static final byte KOTNATOID = 31;
    static final byte KOTDOMOID = 32;
    static final byte KOTUND1OID = 33;
    static final byte KOTCLBOID = 34;
    static final byte KOTBLBOID = 35;
    static final byte KOTCFLOID = 36;
    static final byte KOTBFLOID = 37;
    static final byte KOTOIDOID = 38;
    static final byte KOTCAROID = 39;
    static final byte KOTCANOID = 40;
    static final byte KOTLPTOID = 41;
    static final byte KOTBRIOID = 42;
    static final byte KOTUCOOID = 43;
    static final byte KOTRECOID = 44;
    static final byte KOTRCUOID = 45;
    static final byte KOTBOOOID = 46;
    static final byte KOTRIDOID = 47;
    static final byte KOTPLOOID = 48;
    static final byte KOTPLROID = 49;
    static final byte KOTPBIOID = 50;
    static final byte KOTPINOID = 51;
    static final byte KOTPNAOID = 52;
    static final byte KOTPNNOID = 53;
    static final byte KOTPPOOID = 54;
    static final byte KOTPPNOID = 55;
    static final byte KOTPSTOID = 56;
    static final byte KOTEX1OID = 57;
    static final byte KOTOPQOID = 58;
    static final byte KOTTMOID = 59;
    static final byte KOTTMTZOID = 60;
    static final byte KOTTSOID = 61;
    static final byte KOTTSTZOID = 62;
    static final byte KOTIYMOID = 63;
    static final byte KOTIDSOID = 64;
    static final byte KOTTSIMPTZOID = 65;
    static final byte KOTTBXOID = 66;
    static final byte KOTADXOID = 67;
    static final byte KOTOIDBFLT = 68;
    static final byte KOTOIDBDBL = 69;
    static final byte KOTURDOID = 70;
    static final byte KOTLASTOID = 71;
    static final byte[] KOTTDEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1};
    static final byte[] KOTTBEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 2};
    static final byte[] KOTADEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3};
    static final byte[] KOTMDEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4};
    static final byte[] KOTTBXEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 66};
    static final byte[] KOTADXEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 67};
    static final byte[] KOTTDTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    static final byte[] KOTTBTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2};
    static final byte[] KOTADTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3};
    static final byte[] KOTMDTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5};
    static final byte[] KOTMITOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6};
    static final byte[] KOTEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7};
    static final byte[] KOTEX1TOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57};
    static final byte[] KOTTBXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66};
    static final byte[] KOTADXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67};
    public static final byte[] RAWTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23};
    public static final byte[] ANYTYPETOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 16};
    public static final byte[] ANYDATATOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 17};
    public static final byte[] ANYDATASETTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 18};
    public static final byte[] XMLTYPETOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 0};
    static final short SQLT_NONE = 0;
    static final short SQLT_CHR = 1;
    static final short SQLT_NUM = 2;
    static final short SQLT_INT = 3;
    static final short SQLT_FLT = 4;
    static final short SQLT_STR = 5;
    static final short SQLT_VNU = 6;
    static final short SQLT_PDN = 7;
    static final short SQLT_LNG = 8;
    static final short SQLT_VCS = 9;
    static final short SQLT_NON = 10;
    static final short SQLT_RID = 11;
    static final short SQLT_DAT = 12;
    static final short SQLT_VBI = 15;
    static final short SQLT_BFLOAT = 21;
    static final short SQLT_BDOUBLE = 22;
    static final short SQLT_BIN = 23;
    static final short SQLT_LBI = 24;
    static final short SQLT_UIN = 68;
    static final short SQLT_SLS = 91;
    static final short SQLT_LVC = 94;
    static final short SQLT_LVB = 95;
    static final short SQLT_AFC = 96;
    static final short SQLT_AVC = 97;
    static final short SQLT_IBFLOAT = 100;
    static final short SQLT_IBDOUBLE = 101;
    static final short SQLT_CUR = 102;
    static final short SQLT_RDD = 104;
    static final short SQLT_LAB = 105;
    static final short SQLT_OSL = 106;
    static final short SQLT_NTY = 108;
    static final short SQLT_REF = 110;
    static final short SQLT_CLOB = 112;
    static final short SQLT_BLOB = 113;
    static final short SQLT_BFILEE = 114;
    static final short SQLT_FILE = 114;
    static final short SQLT_CFILEE = 115;
    static final short SQLT_RSET = 116;
    static final short SQLT_SVT = 118;
    static final short SQLT_NCO = 122;
    static final short SQLT_DTR = 152;
    static final short SQLT_DUN = 153;
    static final short SQLT_DOP = 154;
    static final short SQLT_VST = 155;
    static final short SQLT_ODT = 156;
    static final short SQLT_DOL = 172;
    static final short SQLT_DATE = 184;
    static final short SQLT_TIME = 185;
    static final short SQLT_TIME_TZ = 186;
    static final short SQLT_TIMESTAMP = 187;
    static final short SQLT_TIMESTAMP_TZ = 188;
    static final short SQLT_INTERVAL_YM = 189;
    static final short SQLT_INTERVAL_DS = 190;
    static final short SQLT_TIMESTAMP_LTZ = 232;
    static final short SQLT_PNTY = 241;
    static final short SQLT_CFILE = 115;
    static final short SQLT_BFILE = 114;
    static final short SQLT_REC = 250;
    static final short SQLT_TAB = 251;
    static final short SQLT_BOL = 252;
    static final short SQLCS_IMPLICIT = 1;
    static final short SQLCS_NCHAR = 2;
    static final short SQLCS_EXPLICIT = 3;
    static final short SQLCS_FLEXIBLE = 4;
    static final short SQLCS_LIT_NULL = 5;
    static final short SQLT_XDP = 103;
    static final short SQLT_OKO = 107;
    static final short SQLT_INTY = 109;
    static final short SQLT_IREF = 111;
    static final short SQLT_DCLOB = 195;
    public static final short TYPECODE_REF = 110;
    public static final short TYPECODE_DATE = 12;
    public static final short TYPECODE_SIGNED8 = 27;
    public static final short TYPECODE_SIGNED16 = 28;
    public static final short TYPECODE_SIGNED32 = 29;
    public static final short TYPECODE_REAL = 21;
    public static final short TYPECODE_DOUBLE = 22;
    public static final short TYPECODE_BFLOAT = 100;
    public static final short TYPECODE_BDOUBLE = 101;
    public static final short TYPECODE_FLOAT = 4;
    public static final short TYPECODE_NUMBER = 2;
    public static final short TYPECODE_DECIMAL = 7;
    public static final short TYPECODE_UNSIGNED8 = 23;
    public static final short TYPECODE_UNSIGNED16 = 25;
    public static final short TYPECODE_UNSIGNED32 = 26;
    public static final short TYPECODE_OCTET = 245;
    public static final short TYPECODE_SMALLINT = 246;
    public static final short TYPECODE_INTEGER = 3;
    public static final short TYPECODE_RAW = 95;
    public static final short TYPECODE_PTR = 32;
    public static final short TYPECODE_VARCHAR2 = 9;
    public static final short TYPECODE_CHAR = 96;
    public static final short TYPECODE_VARCHAR = 1;
    public static final short TYPECODE_MLSLABEL = 105;
    public static final short TYPECODE_VARRAY = 247;
    public static final short TYPECODE_TABLE = 248;
    public static final short TYPECODE_OBJECT = 108;
    public static final short TYPECODE_OPAQUE = 58;
    public static final short TYPECODE_NAMEDCOLLECTION = 122;
    public static final short TYPECODE_BLOB = 113;
    public static final short TYPECODE_BFILE = 114;
    public static final short TYPECODE_CLOB = 112;
    public static final short TYPECODE_CFILE = 115;
    public static final short TYPECODE_TIME = 185;
    public static final short TYPECODE_TIME_TZ = 186;
    public static final short TYPECODE_TIMESTAMP = 187;
    public static final short TYPECODE_TIMESTAMP_TZ = 188;
    public static final short TYPECODE_TIMESTAMP_LTZ = 232;
    public static final short TYPECODE_INTERVAL_YM = 189;
    public static final short TYPECODE_INTERVAL_DS = 190;
    public static final short TYPECODE_UROWID = 104;
    public static final short TYPECODE_OTMFIRST = 228;
    public static final short TYPECODE_OTMLAST = 320;
    public static final short TYPECODE_SYSFIRST = 228;
    public static final short TYPECODE_SYSLAST = 235;
    public static final short TYPECODE_PLS_INTEGER = 266;
    public static final short TYPECODE_ITABLE = 251;
    public static final short TYPECODE_RECORD = 250;
    public static final short TYPECODE_BOOLEAN = 252;
    public static final short TYPECODE_NCHAR = 286;
    public static final short TYPECODE_NVARCHAR2 = 287;
    public static final short TYPECODE_NCLOB = 288;
    public static final short TYPECODE_NONE = 0;
    public static final short TYPECODE_ERRHP = 283;
    public static final short TYPECODE_JDBC_JOBJECT = 2000;
    public static final short TYPECODE_JDBC_STRUCT = 2002;
    public static final short TYPECODE_JDBC_ARRAY = 2003;
    public static final short TYPECODE_JDBC_JOPAQUE = 2000;
    public static final short TYPECODE_JDBC_REF = 2006;
    public static final short TYPECODE_JDBC_JSTRUCT = 2008;
    private static final short TYPECODE_MAXVALUE = 2008;
    static final short[] OID_TO_TYPECODE = new short[71];
    SQLName sqlName;
    OracleNamedType pickler;
    transient OracleConnection connection;
    short internalTypeCode;
    boolean isTransient = false;
    byte[] toid = null;
    int toidVersion = 1;
    long precision;
    byte scale;
    byte[] transientImage = null;
    AttributeDescriptor[] attributesDescriptor = null;
    transient Boolean isInstanciable = null;
    transient String supertype = null;
    transient int numLocalAttrs = -1;
    transient String[] subtypes = null;
    transient String[] attrJavaNames = null;
    private static String[] typeCodeTypeNameMap;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Fri_Jul_31_19:30:28_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    void copyDescriptor(TypeDescriptor typeDescriptor) {
        this.sqlName = typeDescriptor.sqlName;
        this.pickler = typeDescriptor.pickler;
        this.connection = typeDescriptor.connection;
        this.internalTypeCode = typeDescriptor.internalTypeCode;
        this.isTransient = typeDescriptor.isTransient;
        this.toid = typeDescriptor.toid;
        this.toidVersion = typeDescriptor.toidVersion;
        this.precision = typeDescriptor.precision;
        this.scale = typeDescriptor.scale;
        this.transientImage = typeDescriptor.transientImage;
        this.attributesDescriptor = typeDescriptor.attributesDescriptor;
        this.isInstanciable = typeDescriptor.isInstanciable;
        this.supertype = typeDescriptor.supertype;
        this.numLocalAttrs = typeDescriptor.numLocalAttrs;
        this.subtypes = typeDescriptor.subtypes;
        this.attrJavaNames = typeDescriptor.attrJavaNames;
    }

    protected TypeDescriptor(short s2) {
        this.internalTypeCode = s2;
    }

    protected TypeDescriptor(short s2, String string, Connection connection) throws SQLException {
        this.internalTypeCode = s2;
        if (string == null || connection == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.setPhysicalConnectionOf(connection);
        this.sqlName = new SQLName(string, this.getInternalConnection());
    }

    protected TypeDescriptor(short s2, SQLName sQLName, Connection connection) throws SQLException {
        this.internalTypeCode = s2;
        if (sQLName == null || connection == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.sqlName = sQLName;
        this.setPhysicalConnectionOf(connection);
    }

    protected TypeDescriptor(short s2, SQLName sQLName, OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        this.internalTypeCode = s2;
        if (sQLName == null || oracleTypeADT == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.sqlName = sQLName;
        if (connection != null) {
            this.setPhysicalConnectionOf(connection);
        }
        this.pickler = oracleTypeADT;
        this.pickler.setDescriptor(this);
    }

    protected TypeDescriptor(short s2, OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        this.internalTypeCode = s2;
        if (oracleTypeADT == null || connection == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.setPhysicalConnectionOf(connection);
        this.sqlName = null;
        this.pickler = oracleTypeADT;
        this.pickler.setDescriptor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            if (this.sqlName == null) {
                this.initSQLName();
            }
            String string = null;
            if (this.sqlName != null) {
                string = this.sqlName.getName();
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLName getSQLName() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            if (this.sqlName == null) {
                this.initSQLName();
            }
            return this.sqlName;
        }
    }

    void initSQLName() throws SQLException {
        if (!this.isTransient) {
            if (this.connection == null) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.pickler != null) {
                this.sqlName = new SQLName(this.pickler.getFullName(), this.connection);
            } else if (this.toid != null) {
                String string = OracleTypeADT.toid2typename(this.connection, this.toid);
                this.sqlName = new SQLName(string, this.connection);
                TypeDescriptor typeDescriptor = null;
                String string2 = this.sqlName.getName();
                typeDescriptor = (TypeDescriptor)this.connection.getDescriptor(string2);
                if (typeDescriptor != null) {
                    this.copyDescriptor(typeDescriptor);
                }
            } else if (this.internalTypeCode == 108 || this.internalTypeCode == 122) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
    }

    public String getSchemaName() throws SQLException {
        String string = null;
        if (this.sqlName == null) {
            this.initSQLName();
        }
        if (this.sqlName != null) {
            string = this.sqlName.getSchema();
        }
        return string;
    }

    public String getTypeName() throws SQLException {
        String string = null;
        if (this.sqlName == null) {
            this.initSQLName();
        }
        if (this.sqlName != null) {
            string = this.sqlName.getSimpleName();
        }
        return string;
    }

    public OracleNamedType getPickler() {
        return this.pickler;
    }

    public OracleConnection getInternalConnection() {
        return this.connection;
    }

    public void setPhysicalConnectionOf(Connection connection) {
        this.connection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
    }

    public int getTypeCode() throws SQLException {
        return this.internalTypeCode;
    }

    public String getTypeCodeName() throws SQLException {
        return TypeDescriptor.getTypeCodeTypeNameMap()[this.getTypeCode()];
    }

    private static String[] getTypeCodeTypeNameMap() throws SQLException {
        if (typeCodeTypeNameMap == null) {
            String[] stringArray = new String[2009];
            Class<?> clazz = null;
            try {
                clazz = Class.forName("oracle.sql.TypeDescriptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                SQLException sQLException = DatabaseError.createSqlException(null, 1, "TypeDescriptor.getTypeCodeName: got a ClassNotFoundException: " + classNotFoundException.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Field[] fieldArray = clazz.getFields();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                if (!fieldArray[i2].getName().startsWith("TYPECODE_")) continue;
                try {
                    stringArray[fieldArray[i2].getInt(null)] = fieldArray[i2].getName();
                    continue;
                }
                catch (Exception exception) {
                    SQLException sQLException = DatabaseError.createSqlException(null, 1, "TypeDescriptor.getTypeCodeName: " + exception.getMessage());
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
            typeCodeTypeNameMap = stringArray;
        }
        return typeCodeTypeNameMap;
    }

    public short getInternalTypeCode() throws SQLException {
        return this.internalTypeCode;
    }

    public static TypeDescriptor getTypeDescriptor(String string, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        TypeDescriptor typeDescriptor = null;
        try {
            SQLName sQLName = new SQLName(string, oracleConnection);
            String string2 = sQLName.getName();
            typeDescriptor = (TypeDescriptor)oracleConnection.getDescriptor(string2);
            if (typeDescriptor == null) {
                OracleTypeADT oracleTypeADT = new OracleTypeADT(string2, oracleConnection);
                OracleConnection oracleConnection2 = (OracleConnection)oracleConnection;
                oracleTypeADT.init(oracleConnection2);
                OracleNamedType oracleNamedType = oracleTypeADT.cleanup();
                switch (oracleNamedType.getTypeCode()) {
                    case 2002: 
                    case 2008: {
                        typeDescriptor = new StructDescriptor(sQLName, (OracleTypeADT)oracleNamedType, (Connection)oracleConnection);
                        break;
                    }
                    case 2003: {
                        typeDescriptor = new ArrayDescriptor(sQLName, (OracleTypeCOLLECTION)oracleNamedType, (Connection)oracleConnection);
                        break;
                    }
                    case 2007: {
                        typeDescriptor = new OpaqueDescriptor(sQLName, (OracleTypeOPAQUE)oracleNamedType, (Connection)oracleConnection);
                        break;
                    }
                    default: {
                        SQLException sQLException = DatabaseError.createSqlException(null, 1);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                }
                oracleConnection.putDescriptor(string2, typeDescriptor);
                oracleNamedType.setDescriptor(typeDescriptor);
            }
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                SQLException sQLException = DatabaseError.createSqlException(null, (SQLException)exception, 60, "Unable to resolve type \"" + string + "\"");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            SQLException sQLException = DatabaseError.createSqlException(null, 60, "Unable to resolve type \"" + string + "\"");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return typeDescriptor;
    }

    public static TypeDescriptor getTypeDescriptor(String string, oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, long l2) throws SQLException {
        TypeDescriptor typeDescriptor = null;
        String string2 = TypeDescriptor.getSubtypeName(oracleConnection, byArray, l2);
        if (string2 == null) {
            string2 = string;
        }
        if ((typeDescriptor = (TypeDescriptor)oracleConnection.getDescriptor(string2)) == null) {
            SQLName sQLName = new SQLName(string2, oracleConnection);
            OracleTypeADT oracleTypeADT = new OracleTypeADT(string2, oracleConnection);
            OracleConnection oracleConnection2 = (OracleConnection)oracleConnection;
            oracleTypeADT.init(oracleConnection2);
            OracleNamedType oracleNamedType = oracleTypeADT.cleanup();
            switch (oracleNamedType.getTypeCode()) {
                case 2002: 
                case 2008: {
                    typeDescriptor = new StructDescriptor(sQLName, (OracleTypeADT)oracleNamedType, (Connection)oracleConnection);
                    break;
                }
                case 2003: {
                    typeDescriptor = new ArrayDescriptor(sQLName, (OracleTypeCOLLECTION)oracleNamedType, (Connection)oracleConnection);
                    break;
                }
                case 2007: {
                    typeDescriptor = new OpaqueDescriptor(sQLName, (OracleTypeOPAQUE)oracleNamedType, (Connection)oracleConnection);
                    break;
                }
                default: {
                    SQLException sQLException = DatabaseError.createSqlException(null, 1);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
            oracleConnection.putDescriptor(string2, typeDescriptor);
        }
        return typeDescriptor;
    }

    @Override
    public Datum toDatum(Connection connection) throws SQLException {
        this.connection = (OracleConnection)connection;
        OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor("SYS.ANYTYPE", connection);
        byte[] byArray = new byte[this.getOpaqueImageTypeSize()];
        this.pickleOpaqueTypeImage(byArray, 0, false);
        OPAQUE oPAQUE = new OPAQUE(opaqueDescriptor, this.connection, byArray);
        oPAQUE.setShareBytes(oPAQUE.toBytes());
        return oPAQUE;
    }

    /*
     * Enabled aggressive block sorting
     */
    static TypeDescriptor unpickleOpaqueTypeImage(PickleContext pickleContext, Connection connection, short[] sArray) throws SQLException {
        byte[] byArray;
        int n2;
        TypeDescriptor typeDescriptor;
        block13: {
            block17: {
                AttributeDescriptor[] attributeDescriptorArray;
                block15: {
                    int n3;
                    block16: {
                        block14: {
                            block11: {
                                block10: {
                                    block12: {
                                        byte[] byArray2 = null;
                                        typeDescriptor = null;
                                        n2 = pickleContext.offset();
                                        byArray = pickleContext.image();
                                        pickleContext.skipBytes(1);
                                        short s2 = (short)pickleContext.readUB2();
                                        sArray[0] = (short)pickleContext.readUB2();
                                        if ((s2 & 0x20) != 0) {
                                            SQLException sQLException = DatabaseError.createSqlException(null, 178);
                                            sQLException.fillInStackTrace();
                                            throw sQLException;
                                        }
                                        if ((s2 & 1) != 0) break block11;
                                        if ((s2 & 2) != 0 && sArray[0] != 110) break block12;
                                        byArray2 = pickleContext.readDataValue(16);
                                        int n4 = pickleContext.readUB2();
                                        String string = (String)((OracleConnection)connection).getDescriptor(byArray2);
                                        typeDescriptor = (TypeDescriptor)((OracleConnection)connection).getDescriptor(string);
                                        if (typeDescriptor == null) {
                                            if (sArray[0] == 122) {
                                                typeDescriptor = new ArrayDescriptor(byArray2, n4, connection);
                                                break block10;
                                            } else if (sArray[0] == 108 || sArray[0] == 110) {
                                                typeDescriptor = new StructDescriptor(byArray2, n4, connection);
                                                break block10;
                                            } else {
                                                if (sArray[0] != 58) {
                                                    SQLException sQLException = DatabaseError.createSqlException(null, 178);
                                                    sQLException.fillInStackTrace();
                                                    throw sQLException;
                                                }
                                                typeDescriptor = new OpaqueDescriptor(byArray2, n4, connection);
                                            }
                                        }
                                        break block10;
                                    }
                                    typeDescriptor = new TypeDescriptor(sArray[0]);
                                }
                                typeDescriptor.setTransient(false);
                                break block13;
                            }
                            n3 = (int)pickleContext.readUB4();
                            if (sArray[0] != 108) break block14;
                            attributeDescriptorArray = null;
                            if (n3 <= 0) break block15;
                            attributeDescriptorArray = new AttributeDescriptor[n3];
                            break block16;
                        }
                        if (n3 != 1) {
                            SQLException sQLException = DatabaseError.createSqlException(null, 178);
                            sQLException.fillInStackTrace();
                            throw sQLException;
                        }
                        byte by = pickleContext.readByte();
                        typeDescriptor = Kotad.unpickleTypeDescriptorImage(pickleContext);
                        break block17;
                    }
                    for (int i2 = 0; i2 < n3; ++i2) {
                        byte by = pickleContext.readByte();
                        attributeDescriptorArray[i2] = Kotad.unpickleAttributeImage(by == 2, pickleContext);
                        if (by == 2) continue;
                        short[] sArray2 = new short[1];
                        attributeDescriptorArray[i2].setTypeDescriptor(TypeDescriptor.unpickleOpaqueTypeImage(pickleContext, connection, sArray2));
                    }
                }
                typeDescriptor = new StructDescriptor(attributeDescriptorArray, connection);
            }
            typeDescriptor.setTransient(true);
        }
        if (typeDescriptor.isTransient()) {
            int n5 = pickleContext.offset();
            byte[] byArray3 = new byte[n5 - n2];
            System.arraycopy(byArray, n2, byArray3, 0, byArray3.length);
            typeDescriptor.setTransientImage(byArray3);
        }
        return typeDescriptor;
    }

    void setTransientImage(byte[] byArray) {
        this.transientImage = byArray;
    }

    void setTransient(boolean bl) {
        this.isTransient = bl;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    int getOpaqueImageTypeSize() {
        int n2 = 0;
        if (this.isTransient) {
            n2 = this.transientImage.length;
        } else {
            n2 = 5;
            if (this.toid != null && this.toid.length == 16) {
                n2 = 23;
            }
        }
        return n2;
    }

    int pickleOpaqueTypeImage(byte[] byArray, int n2, boolean bl) {
        if (this.isTransient) {
            System.arraycopy(this.transientImage, 0, byArray, n2, this.transientImage.length);
            n2 += this.transientImage.length;
        } else {
            boolean bl2 = false;
            if (this.toid != null && this.toid.length == 16) {
                bl2 = true;
            }
            byArray[n2++] = 1;
            int n3 = this.internalTypeCode;
            if (bl) {
                n3 = 110;
            }
            int n4 = 512;
            if (n3 != 108 && n3 != 122) {
                n4 |= 2;
            }
            if (bl2 && n3 != 110) {
                n4 |= 4;
            }
            byArray[n2++] = (byte)((n4 & 0xFF00) >> 8 & 0xFF);
            byArray[n2++] = (byte)(n4 & 0xFF);
            byArray[n2++] = (byte)((n3 & 0xFF00) >> 8 & 0xFF);
            byArray[n2++] = (byte)(n3 & 0xFF);
            if (bl2) {
                System.arraycopy(this.toid, 0, byArray, n2, this.toid.length);
                n2 += this.toid.length;
                byArray[n2++] = (byte)((this.toidVersion & 0xFF00) >> 8 & 0xFF);
                byArray[n2++] = (byte)(this.toidVersion & 0xFF);
            }
        }
        return n2;
    }

    public void setPrecision(long l2) {
        this.precision = l2;
    }

    public long getPrecision() {
        return this.precision;
    }

    public void setScale(byte by) {
        this.scale = by;
    }

    public byte getScale() {
        return this.scale;
    }

    public boolean isInHierarchyOf(String string) throws SQLException {
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            if (this.sqlName == null) {
                this.initSQLName();
            }
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        objectOutputStream.writeObject(this.sqlName);
        objectOutputStream.writeObject(this.pickler);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.sqlName = (SQLName)objectInputStream.readObject();
        this.pickler = (OracleNamedType)objectInputStream.readObject();
    }

    public void setConnection(Connection connection) throws SQLException {
        this.setPhysicalConnectionOf(connection);
        this.pickler.setConnection(this.getInternalConnection());
    }

    public static String getSubtypeName(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, long l2) throws SQLException {
        if (byArray == null || byArray.length == 0 || oracleConnection == null) {
            SQLException sQLException = DatabaseError.createSqlException(null, 68, " 'image' should not be empty and 'conn' should not be null. ");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string = OracleTypeADT.getSubtypeName(oracleConnection, byArray, l2);
        return string;
    }

    public void initMetadataRecursively() throws SQLException {
        if (this.pickler != null) {
            this.pickler.initMetadataRecursively();
        }
    }

    public void initNamesRecursively() throws SQLException {
        if (this.pickler != null) {
            this.pickler.initNamesRecursively();
        }
    }

    public void fixupConnection(OracleConnection oracleConnection) throws SQLException {
        if (this.connection == null) {
            this.connection = oracleConnection;
        }
        if (this.pickler != null) {
            this.pickler.fixupConnection(oracleConnection);
        }
    }

    public String toXMLString() throws SQLException {
        return this.toXMLString(false);
    }

    public String toXMLString(boolean bl) throws SQLException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.printXMLHeader(printWriter);
        this.printXML(printWriter, 0, bl);
        return stringWriter.getBuffer().substring(0);
    }

    public void printXML(PrintStream printStream) throws SQLException {
        this.printXML(printStream, false);
    }

    public void printXML(PrintStream printStream, boolean bl) throws SQLException {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.printXMLHeader(printWriter);
        this.printXML(printWriter, 0, bl);
    }

    void printXML(PrintWriter printWriter, int n2, boolean bl) throws SQLException {
        String string = this.tagName();
        printWriter.println("<" + string + " sqlName=\"" + this.sqlName + "\" >");
        if (this.pickler != null) {
            this.pickler.printXML(printWriter, n2 + 1, bl);
        }
        printWriter.println("</" + string + ">");
    }

    String tagName() {
        return "TypeDescriptor";
    }

    void printXMLHeader(PrintWriter printWriter) throws SQLException {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    static {
        TypeDescriptor.OID_TO_TYPECODE[8] = 12;
        TypeDescriptor.OID_TO_TYPECODE[9] = 27;
        TypeDescriptor.OID_TO_TYPECODE[10] = 28;
        TypeDescriptor.OID_TO_TYPECODE[11] = 29;
        TypeDescriptor.OID_TO_TYPECODE[12] = 21;
        TypeDescriptor.OID_TO_TYPECODE[13] = 22;
        TypeDescriptor.OID_TO_TYPECODE[14] = 4;
        TypeDescriptor.OID_TO_TYPECODE[15] = 2;
        TypeDescriptor.OID_TO_TYPECODE[16] = 7;
        TypeDescriptor.OID_TO_TYPECODE[17] = 23;
        TypeDescriptor.OID_TO_TYPECODE[18] = 25;
        TypeDescriptor.OID_TO_TYPECODE[19] = 26;
        TypeDescriptor.OID_TO_TYPECODE[20] = 245;
        TypeDescriptor.OID_TO_TYPECODE[21] = 246;
        TypeDescriptor.OID_TO_TYPECODE[22] = 3;
        TypeDescriptor.OID_TO_TYPECODE[23] = 95;
        TypeDescriptor.OID_TO_TYPECODE[24] = 32;
        TypeDescriptor.OID_TO_TYPECODE[25] = 9;
        TypeDescriptor.OID_TO_TYPECODE[26] = 96;
        TypeDescriptor.OID_TO_TYPECODE[27] = 1;
        TypeDescriptor.OID_TO_TYPECODE[28] = 105;
        TypeDescriptor.OID_TO_TYPECODE[29] = 247;
        TypeDescriptor.OID_TO_TYPECODE[30] = 248;
        TypeDescriptor.OID_TO_TYPECODE[31] = 108;
        TypeDescriptor.OID_TO_TYPECODE[32] = 0;
        TypeDescriptor.OID_TO_TYPECODE[33] = 0;
        TypeDescriptor.OID_TO_TYPECODE[34] = 112;
        TypeDescriptor.OID_TO_TYPECODE[35] = 113;
        TypeDescriptor.OID_TO_TYPECODE[36] = 115;
        TypeDescriptor.OID_TO_TYPECODE[37] = 114;
        TypeDescriptor.OID_TO_TYPECODE[38] = 0;
        TypeDescriptor.OID_TO_TYPECODE[39] = 0;
        TypeDescriptor.OID_TO_TYPECODE[40] = 0;
        TypeDescriptor.OID_TO_TYPECODE[41] = 0;
        TypeDescriptor.OID_TO_TYPECODE[42] = 0;
        TypeDescriptor.OID_TO_TYPECODE[43] = 0;
        TypeDescriptor.OID_TO_TYPECODE[44] = 0;
        TypeDescriptor.OID_TO_TYPECODE[45] = 0;
        TypeDescriptor.OID_TO_TYPECODE[46] = 0;
        TypeDescriptor.OID_TO_TYPECODE[47] = 0;
        TypeDescriptor.OID_TO_TYPECODE[48] = 0;
        TypeDescriptor.OID_TO_TYPECODE[49] = 0;
        TypeDescriptor.OID_TO_TYPECODE[50] = 0;
        TypeDescriptor.OID_TO_TYPECODE[51] = 0;
        TypeDescriptor.OID_TO_TYPECODE[52] = 0;
        TypeDescriptor.OID_TO_TYPECODE[53] = 0;
        TypeDescriptor.OID_TO_TYPECODE[54] = 0;
        TypeDescriptor.OID_TO_TYPECODE[55] = 0;
        TypeDescriptor.OID_TO_TYPECODE[56] = 0;
        TypeDescriptor.OID_TO_TYPECODE[57] = 0;
        TypeDescriptor.OID_TO_TYPECODE[58] = 58;
        TypeDescriptor.OID_TO_TYPECODE[59] = 185;
        TypeDescriptor.OID_TO_TYPECODE[60] = 186;
        TypeDescriptor.OID_TO_TYPECODE[61] = 187;
        TypeDescriptor.OID_TO_TYPECODE[62] = 188;
        TypeDescriptor.OID_TO_TYPECODE[63] = 189;
        TypeDescriptor.OID_TO_TYPECODE[64] = 190;
        TypeDescriptor.OID_TO_TYPECODE[65] = 232;
        TypeDescriptor.OID_TO_TYPECODE[66] = 0;
        TypeDescriptor.OID_TO_TYPECODE[67] = 0;
        TypeDescriptor.OID_TO_TYPECODE[68] = 100;
        TypeDescriptor.OID_TO_TYPECODE[69] = 101;
        TypeDescriptor.OID_TO_TYPECODE[70] = 104;
        typeCodeTypeNameMap = null;
        try {
            TypeDescriptor.getTypeCodeTypeNameMap();
        }
        catch (Exception exception) {
            // empty catch block
        }
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    }
}

