/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.b.a;
import dm.jdbc.b.d;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbOutputStream;
import dm.jdbc.driver.DmdbReader;
import dm.jdbc.driver.DmdbWriter;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class DmdbClob
extends a
implements Clob {
    public String data = "";
    public String gm = null;

    protected DmdbClob(byte[] byArray, DmdbConnection dmdbConnection, d d2, boolean bl) {
        super(byArray, (byte)1, dmdbConnection, d2);
        this.gm = dmdbConnection.getServerEncoding();
        if (this.v) {
            int n2 = dmdbConnection.gG ? 43 : 13;
            this.data = ByteUtil.getString(byArray, n2, (int)this.getLengthFromHead(byArray), this.gm);
            this.length = this.data.length();
        } else if (bl) {
            this.loadAllData();
        }
    }

    protected DmdbClob(String string, DmdbConnection dmdbConnection) {
        super((byte)0, dmdbConnection);
        this.gm = dmdbConnection.getServerEncoding();
        this.data = string;
        this.length = this.data.length();
    }

    public static DmdbClob newInstance(byte[] byArray, DmdbConnection dmdbConnection, d d2, boolean bl) {
        return new DmdbClob(byArray, dmdbConnection, d2, bl);
    }

    public static DmdbClob newInstance(String string, DmdbConnection dmdbConnection) {
        return new DmdbClob(string, dmdbConnection);
    }

    public static DmdbClob getEmptyClob() {
        try {
            return new DmdbClob("", new DmdbConnection(null));
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public String do_getSubString(long l2, int n2) {
        long l3;
        this.checkFreed();
        if (l2 < 1L || n2 < 0) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwException(new String[0]);
        }
        if ((l3 = this.do_length() - --l2) < 0L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwException(new String[0]);
        }
        n2 = (int)((long)n2 > l3 ? l3 : (long)n2);
        if (this.L || this.v || this.P) {
            if (l2 > this.length) {
                DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwException(new String[0]);
            }
            return this.data.substring((int)l2, (int)l2 + n2);
        }
        this.K.checkClosed();
        return this.K.hc.a(this, (int)l2, n2);
    }

    public DmdbReader do_getCharacterStream() {
        this.checkFreed();
        return new DmdbReader(this);
    }

    public DmdbInputStream do_getAsciiStream() {
        this.checkFreed();
        return new DmdbInputStream(this);
    }

    public long do_position(String string, long l2) {
        long l3;
        this.checkFreed();
        if (l2 < 1L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwException(new String[0]);
        }
        if (StringUtil.isEmpty(string)) {
            return -1L;
        }
        if (this.L || this.v || this.P) {
            if ((long)string.length() > this.length - l2 + 1L) {
                return -1L;
            }
            l3 = this.data.indexOf(string, (int)l2);
        } else {
            String string2 = this.do_getSubString(l2, (int)(this.do_length() - l2 + 1L));
            if (string2.length() < string.length()) {
                return -1L;
            }
            l3 = string2.indexOf(string);
        }
        if (l3 >= 0L) {
            ++l3;
        }
        return l3;
    }

    public long do_position(Clob clob, long l2) {
        return this.do_position(clob.getSubString(1L, (int)clob.length()), l2);
    }

    public int do_setString(long l2, String string, int n2, int n3) {
        this.checkFreed();
        if (l2 < 1L || n2 < 0 || n3 < 0 || n2 + n3 > string.length()) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwException(new String[0]);
        }
        if (!this.M) {
            DBError.ECJDBC_RESULTSET_IS_READ_ONLY.throwException(new String[0]);
        }
        string = string.substring(n2, n2 + n3);
        --l2;
        int n4 = 0;
        if (this.L || this.P) {
            if (l2 > this.length) {
                DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwException(new String[0]);
            }
            this.setLocalData((int)l2, string);
            n4 = string.length();
        } else {
            this.K.checkClosed();
            int n5 = this.K.hc.a(this, (int)l2, string, this.gm);
            if (this.w == -1) {
                this.setLocalData((int)l2, string);
            } else {
                this.v = false;
                this.length = -1L;
            }
            n4 = n5;
        }
        this.R = true;
        return n4;
    }

    public int do_setString(long l2, String string) {
        return this.do_setString(l2, string, 0, string.length());
    }

    public DmdbOutputStream do_setAsciiStream(long l2) {
        this.checkFreed();
        if (this.O && l2 == 0L) {
            l2 = 1L;
        }
        if (l2 < 1L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwException(new String[0]);
        }
        return new DmdbOutputStream(this, l2);
    }

    public DmdbOutputStream getAsciiOutputStream() {
        return this.do_setAsciiStream(1L);
    }

    public DmdbOutputStream getAsciiOutputStream(long l2) {
        return this.do_setAsciiStream(l2);
    }

    public DmdbWriter do_setCharacterStream(long l2) {
        this.checkFreed();
        if (this.O && l2 == 0L) {
            l2 = 1L;
        }
        if (l2 < 1L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwException(new String[0]);
        }
        return new DmdbWriter(this, l2);
    }

    public void do_truncate(long l2) {
        this.checkFreed();
        if (l2 < 0L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwException(new String[0]);
        }
        if (!this.M) {
            DBError.ECJDBC_RESULTSET_IS_READ_ONLY.throwException(new String[0]);
        }
        if (this.L || this.P) {
            if (l2 > this.length) {
                return;
            }
            this.data = this.data.substring(0, (int)l2);
            this.length = this.data.length();
        } else {
            this.K.checkClosed();
            this.length = this.K.hc.a(this, (int)l2);
            if (this.w == -1) {
                this.data = this.data.substring(0, (int)this.length);
            }
        }
        this.R = true;
    }

    @Override
    public void do_free() {
        super.do_free();
        this.data = null;
    }

    public DmdbReader do_getCharacterStream(long l2, long l3) {
        this.checkFreed();
        return new DmdbReader(this, l2, l3);
    }

    @Override
    protected void loadAllData() {
        this.checkFreed();
        if (this.L || this.v || this.P) {
            return;
        }
        this.data = this.do_getSubString(1L, (int)this.do_length());
        this.P = true;
    }

    public Object clone() {
        DmdbClob dmdbClob = null;
        try {
            dmdbClob = (DmdbClob)super.clone();
            dmdbClob.data = this.data;
            dmdbClob.gm = this.gm;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return dmdbClob;
    }

    private void setLocalData(int n2, String string) {
        this.data = (long)(n2 + string.length()) >= this.length ? String.valueOf(this.data.substring(0, n2)) + string : String.valueOf(this.data.substring(0, n2)) + string + this.data.substring(n2 + string.length(), this.data.length());
        this.length = this.data.length();
    }

    public byte[] getBytes(long l2, int n2) {
        String string = this.do_getSubString(l2, n2);
        return ByteUtil.getBytes(string, this.gm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_length();
            }
            return this.filterChain.reset().Clob_length(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubString(long l2, int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSubString(l2, n2);
            }
            return this.filterChain.reset().Clob_getSubString(this, l2, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCharacterStream();
            }
            return this.filterChain.reset().Clob_getCharacterStream(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getAsciiStream();
            }
            return this.filterChain.reset().Clob_getAsciiStream(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(String string, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_position(string, l2);
            }
            return this.filterChain.reset().Clob_position(this, string, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(Clob clob, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_position(clob, l2);
            }
            return this.filterChain.reset().Clob_position(this, clob, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setString(long l2, String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setString(l2, string);
            }
            return this.filterChain.reset().Clob_setString(this, l2, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setString(long l2, String string, int n2, int n3) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setString(l2, string, n2, n3);
            }
            return this.filterChain.reset().Clob_setString(this, l2, string, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream setAsciiStream(long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setAsciiStream(l2);
            }
            return this.filterChain.reset().Clob_setAsciiStream(this, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer setCharacterStream(long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setCharacterStream(l2);
            }
            return this.filterChain.reset().Clob_setCharacterStream(this, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_truncate(l2);
            } else {
                this.filterChain.reset().Clob_truncate(this, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() {
        if (this.K == null) {
            return;
        }
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_free();
            } else {
                this.filterChain.reset().Clob_free(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(long l2, long l3) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCharacterStream(l2, l3);
            }
            return this.filterChain.reset().Clob_getCharacterStream(this, l2, l3);
        }
    }
}

