/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.MathUtil;
import java.io.Serializable;
import java.math.BigDecimal;

public class DmdbNumeric
implements Serializable {
    private static final long serialVersionUID = 3847946444882096464L;
    private static final int hS = 38;
    private static final int hT = 21;
    private static final int hU = 128;
    private static final int hV = 193;
    private static final int hW = 62;
    private static final int hX = 61;
    private static final int hY = -64;
    private static final int hZ = 1;
    private static final int ia = 101;
    private int ib = 0;
    private int ic = 0;
    private StringBuilder ie;
    private int prec;
    private int scale;

    private DmdbNumeric() {
    }

    public DmdbNumeric(byte[] byArray, int n2, int n3) {
        this.prec = n2;
        this.scale = n3;
        this.decode(byArray);
    }

    public static DmdbNumeric valueOf(BigDecimal bigDecimal, int n2, int n3) {
        DmdbNumeric dmdbNumeric = new DmdbNumeric();
        dmdbNumeric.prec = n2;
        dmdbNumeric.scale = n3;
        dmdbNumeric.parse(bigDecimal, n2, n3);
        return dmdbNumeric;
    }

    public static DmdbNumeric valueOf(String string, int n2, int n3) {
        DmdbNumeric dmdbNumeric = new DmdbNumeric();
        dmdbNumeric.prec = n2;
        dmdbNumeric.scale = n3;
        dmdbNumeric.parse(string, n2, n3);
        return dmdbNumeric;
    }

    public static DmdbNumeric valueOf(long l2, int n2, int n3) {
        DmdbNumeric dmdbNumeric = new DmdbNumeric();
        dmdbNumeric.prec = n2;
        dmdbNumeric.scale = n3;
        dmdbNumeric.parse(l2, n2, n3);
        return dmdbNumeric;
    }

    public boolean isZero() {
        return this.ib == 0;
    }

    public BigDecimal toBigDecimal() {
        if (this.isZero()) {
            return new BigDecimal("0");
        }
        BigDecimal bigDecimal = new BigDecimal(this.ib < 0 ? "-" + this.ie.toString() : this.ie.toString());
        bigDecimal = bigDecimal.scaleByPowerOfTen(this.ic);
        if ((this.prec > 0 || this.scale > 0) && bigDecimal.scale() > this.scale) {
            bigDecimal = bigDecimal.setScale(this.scale, 4);
        }
        return bigDecimal;
    }

    private void parse(BigDecimal bigDecimal, int n2, int n3) {
        this.ib = bigDecimal.signum();
        if (this.isZero()) {
            return;
        }
        if (n2 != 0 || n3 != 0) {
            bigDecimal = bigDecimal.setScale(n3, 4);
        }
        int n4 = bigDecimal.scale() > 0 ? bigDecimal.scale() : 0;
        int n5 = bigDecimal.precision() - n4;
        this.checkPrec(n5, n2);
        StringBuilder stringBuilder = new StringBuilder(bigDecimal.toPlainString());
        stringBuilder = this.ib < 0 ? stringBuilder.deleteCharAt(0) : stringBuilder;
        int n6 = stringBuilder.indexOf(".");
        int n7 = 0;
        int n8 = 0;
        int n9 = stringBuilder.length();
        if (n6 != -1) {
            if (stringBuilder.charAt(0) == '0') {
                n7 = n8 = 2;
                while (n7 < n9) {
                    if (stringBuilder.charAt(n7) != '0') break;
                    ++n7;
                }
                stringBuilder.delete(0, n7);
                this.movePointLeft(n7 - n8 + stringBuilder.length());
            } else {
                stringBuilder = stringBuilder.deleteCharAt(n6);
                this.movePointLeft(n9 - n6 - 1);
            }
        }
        n9 = stringBuilder.length();
        n7 = n8 = n9 - 1;
        while (n7 > 0) {
            if (stringBuilder.charAt(n7) != '0') break;
            --n7;
        }
        stringBuilder.delete(n7 + 1, n9);
        this.movePointRight(n8 - n7);
        if (MathUtil.isOdd(this.ic)) {
            stringBuilder.append("0");
            --this.ic;
        }
        if (MathUtil.isOdd(stringBuilder.length())) {
            stringBuilder.insert(0, "0");
        }
        this.ie = stringBuilder;
    }

    private void parse(String string, int n2, int n3) {
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(string);
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        }
        this.parse(bigDecimal, n2, n3);
    }

    private void parse(long l2, int n2, int n3) {
        int n4;
        if (l2 == 0L) {
            this.ib = 0;
            return;
        }
        this.ib = l2 > 0L ? 1 : -1;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(l2);
        stringBuilder = this.ib < 0 ? stringBuilder.deleteCharAt(0) : stringBuilder;
        int n5 = stringBuilder.length();
        this.checkPrec(n5, n2);
        int n6 = 0;
        n6 = n4 = n5 - 1;
        while (n6 > 0) {
            if (stringBuilder.charAt(n6) != '0') break;
            --n6;
        }
        stringBuilder.delete(n6 + 1, n5);
        this.movePointRight(n4 - n6);
        if (MathUtil.isOdd(stringBuilder.length())) {
            stringBuilder.insert(0, "0");
        }
        this.ie = stringBuilder;
    }

    private void movePointLeft(int n2) {
        this.ic -= n2;
    }

    private void movePointRight(int n2) {
        this.ic += n2;
    }

    private void decode(byte[] byArray) {
        if (byArray == null || byArray.length == 0 || byArray.length > 21) {
            DBError.ECJDBC_FATAL_ERROR.throwException(new String[0]);
        }
        if (byArray[0] == 128 || byArray.length == 1) {
            return;
        }
        this.ib = (byArray[0] & 0x80) != 0 ? 1 : -1;
        int n2 = ByteUtil.getUB1(byArray, 0);
        int n3 = this.ib > 0 ? n2 - 193 : 62 - n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = 0;
        int n5 = 1;
        while (n5 < byArray.length) {
            int n6 = n4 = this.ib > 0 ? byArray[n5] - 1 : 101 - byArray[n5];
            if (n4 < 0 || n4 > 99) break;
            if (n4 < 10) {
                stringBuilder.append("0");
            }
            stringBuilder.append(n4);
            ++n5;
        }
        this.ie = stringBuilder;
        this.ic = n3 * 2 - (this.ie.length() - 2);
    }

    public byte[] encode() {
        int n2;
        if (this.isZero()) {
            return new byte[]{-128};
        }
        int n3 = (this.ic + this.ie.length()) / 2 - 1;
        if (n3 > 61 || n3 < -64) {
            DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
        }
        n2 = (n2 = this.ie.length() / 2 + 1) > 21 ? 21 : n2;
        byte[] byArray = new byte[n2];
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        while (n6 < n2) {
            n4 = Character.digit(this.ie.charAt(n5++), 10) * 10 + Character.digit(this.ie.charAt(n5++), 10);
            byArray[n6++] = (byte)(this.ib > 0 ? n4 + 1 : 101 - n4);
        }
        byArray[0] = (byte)(this.ib > 0 ? n3 + 193 : 62 - n3);
        return byArray;
    }

    private boolean checkPrec(int n2, int n3) {
        if (n3 > 0 && n2 > n3 || n2 > 38) {
            System.out.println("prec: " + n3 + ", intCount: " + n2);
            DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        BigDecimal bigDecimal = this.toBigDecimal();
        if (this.prec <= 0 && this.scale <= 0) {
            bigDecimal = bigDecimal.stripTrailingZeros();
        }
        return bigDecimal.toString();
    }

    public static void main(String[] stringArray) {
        long l2 = System.currentTimeMillis();
        int n2 = 0;
        while (n2 < 1000000) {
            DmdbNumeric dmdbNumeric = DmdbNumeric.valueOf("43243.232", 0, 0);
            dmdbNumeric.encode();
            ++n2;
        }
        System.out.println("time: " + (System.currentTimeMillis() - l2) + "ms");
    }
}

