/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.a.a;
import dm.jdbc.b.d;
import dm.jdbc.b.h;
import dm.jdbc.b.j;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbBFile;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbReader;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbRowId;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.filter.Filterable;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.StringUtil;
import dm.jdbc.util.UtilBinaryToUnicodeInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class DmdbResultSet
extends Filterable
implements ResultSet {
    public DmdbConnection K;
    public DmdbStatement iG;
    public short iH = 0;
    public d[] iI;
    public Map iJ;
    public byte[][][] iK;
    public int iL = -1;
    public long iM = 0L;
    public long iN = -1L;
    public long iO;
    public boolean iP = false;
    public boolean iQ = false;
    public boolean gl = false;
    public boolean closed = false;
    public SQLWarning iR;
    public int type = 1003;
    public int iS = 1007;
    public int iT = 2;
    public int iU = 1000;
    public int iV;
    public int iW = 0;
    public j[] iX;
    public boolean[] iY = null;
    public j[] iZ;
    public boolean[] ja = null;
    public j[] jb;
    public boolean[] jc;

    public DmdbResultSet(short s2, DmdbStatement dmdbStatement, h h2) {
        this(dmdbStatement, dmdbStatement.iI, h2.ej == null ? new byte[][][]{} : (byte[][][])h2.ej);
        this.iH = s2;
        this.iO = h2.updateCount;
        this.iP = h2.en;
        this.iQ = h2.em;
        int n2 = this.iW = this.iK.length > 0 ? (int)(h2.ek / (long)this.iK.length) : 0;
        if (this.iP) {
            this.iZ = new j[this.iI.length];
            this.ja = new boolean[this.iI.length];
            this.jb = this.iZ;
            this.jc = this.ja;
        }
    }

    private DmdbResultSet(DmdbStatement dmdbStatement, d[] dArray, byte[][][] byArray) {
        super(dmdbStatement.K, null);
        this.iG = dmdbStatement;
        this.K = dmdbStatement.K;
        this.type = this.iG.kB;
        this.iS = this.iG.kC;
        this.iT = this.iG.hd;
        this.iU = this.iG.iU;
        this.iV = this.iG.iV;
        this.iI = dArray == null ? new d[]{} : dArray;
        this.iJ = new HashMap(this.iI.length);
        int n2 = 0;
        while (n2 < this.iI.length) {
            this.iJ.put(this.K.connection_property_ignoreCase ? this.iI[n2].name.toLowerCase() : this.iI[n2].name, n2 + 1);
            ++n2;
        }
        this.iK = byArray == null ? (Object)new byte[0][][] : byArray;
        this.iO = byArray == null ? 0 : byArray.length;
        this.iP = false;
        this.iQ = false;
    }

    public static DmdbResultSet newLocalResultSet(DmdbStatement dmdbStatement, d[] dArray, byte[][][] byArray) {
        return new DmdbResultSet(dmdbStatement, dArray, byArray);
    }

    public static DmdbResultSet newEmptyResultSet(DmdbStatement dmdbStatement) {
        return new DmdbResultSet(dmdbStatement, null, null);
    }

    protected void checkClosed() {
        if (this.closed) {
            DBError.ECJDBC_RESULTSET_CLOSED.throwException(new String[0]);
        }
    }

    public void do_close() {
        if (this.iG != null && this.iG.kN != null && this.iG.kN.contains(this)) {
            this.iG.kN.remove(this);
        }
        if (this.iG != null && this.iG.do_isCloseOnCompletion() && (this.iG.kN == null || this.iG.kN.size() == 0)) {
            this.iG.do_close();
        }
        this.K = null;
        this.iG = null;
        this.iI = null;
        this.iK = null;
        this.iX = null;
        this.iY = null;
        this.iZ = null;
        this.ja = null;
        this.closed = true;
    }

    public SQLWarning do_getWarnings() {
        this.checkClosed();
        return this.iR;
    }

    public void do_clearWarnings() {
        this.checkClosed();
        this.iR = null;
    }

    public String do_getCursorName() {
        this.checkClosed();
        if (this.iG == null) {
            return null;
        }
        if (this.iG.fm == null) {
            this.iG.do_setCursorName("BPXLYBHQ" + this.iG.id);
        }
        return this.iG.fm;
    }

    public DmdbResultSetMetaData do_getMetaData() {
        this.checkClosed();
        return new DmdbResultSetMetaData(this.K, this.iI);
    }

    public boolean do_isBeforeFirst() {
        this.checkClosed();
        return this.iO != 0L && this.iN <= -1L;
    }

    public boolean do_isAfterLast() {
        this.checkClosed();
        return this.iO != 0L && this.iN >= this.iO;
    }

    public boolean do_isFirst() {
        this.checkClosed();
        return this.iN == 0L && this.iO > 0L;
    }

    public boolean do_isLast() {
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwException(new String[0]);
        }
        if (this.iO == Long.MAX_VALUE) {
            this.iO = this.K.hc.a(this);
        }
        return this.iN == this.iO - 1L && this.iO > 0L;
    }

    public void do_beforeFirst() {
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwException(new String[0]);
        }
        this.iN = -1L;
        this.iL = -1;
    }

    public void do_afterLast() {
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwException(new String[0]);
        }
        if (this.iO == Long.MAX_VALUE) {
            this.iO = this.K.hc.a(this);
        }
        this.iN = this.iO;
        this.iL = this.iK == null ? 0 : this.iK.length;
    }

    public boolean do_first() {
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwException(new String[0]);
        }
        return this.do_absolute(1);
    }

    public boolean do_last() {
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwException(new String[0]);
        }
        if (this.iO == Long.MAX_VALUE) {
            this.iO = this.K.hc.a(this);
        }
        return this.iO == 0L ? false : this.do_absolute((int)this.iO);
    }

    public int do_getRow() {
        this.checkClosed();
        return (int)(this.iN + 1L);
    }

    public boolean do_absolute(int n2) {
        this.checkClosed();
        if (n2 == 0) {
            DBError.ECJDBC_INVALUID_ROW_NUMBER.throwException(new String[0]);
        }
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwException(new String[0]);
        }
        long l2 = n2;
        if (n2 < 0) {
            if (this.iO == Long.MAX_VALUE) {
                this.iO = this.K.hc.a(this);
            }
            l2 = this.iO + (long)n2;
        } else {
            --l2;
        }
        if (l2 >= this.iM && l2 < this.iM + (long)this.iK.length) {
            this.iN = l2;
            this.iL = (int)(this.iN - this.iM);
            return true;
        }
        if (l2 >= 0L && l2 < this.iO) {
            this.iN = l2;
            if (this.fetchData(l2)) {
                this.iL = 0;
                return true;
            }
            return false;
        }
        if (n2 > 0) {
            this.iN = this.iO;
            this.iL = this.iK.length;
        } else {
            this.iN = -1L;
            this.iL = -1;
        }
        return false;
    }

    public boolean do_relative(int n2) {
        int n3;
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwException(new String[0]);
        }
        if ((n3 = (int)(this.iN + (long)n2 + 1L)) < 1) {
            this.do_beforeFirst();
            return false;
        }
        if ((long)n3 > this.iO) {
            this.do_afterLast();
            return false;
        }
        return this.do_absolute(n3);
    }

    public boolean do_next() {
        this.checkClosed();
        if (this.iO == 0L) {
            this.iR = DBError.getSQLWarning(DBError.ECJDBC_RESULTSET_EMPTY);
            return false;
        }
        if (this.iN >= this.iO) {
            return false;
        }
        if (this.iN == this.iO - 1L) {
            ++this.iN;
            ++this.iL;
            return false;
        }
        if (this.iN + 1L < this.iM || this.iN + 1L >= this.iM + (long)this.iK.length) {
            if (this.fetchData(this.iN + 1L)) {
                ++this.iN;
                return true;
            }
            ++this.iN;
            ++this.iL;
            return false;
        }
        ++this.iL;
        ++this.iN;
        return true;
    }

    public boolean do_previous() {
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwException(new String[0]);
        }
        if (this.iN <= -1L) {
            return false;
        }
        if (this.iN == 0L) {
            --this.iN;
            --this.iL;
            return false;
        }
        if (this.iN - 1L < this.iM || this.iN - 1L >= this.iM + (long)this.iK.length) {
            int n2 = d.a(this.iI, this.K.gp);
            int n3 = 32640 / n2;
            long l2 = this.iN - (long)(n3 / 2);
            if (l2 < 0L) {
                l2 = 0L;
            }
            this.fetchData(l2);
            this.iL = (int)(this.iN - l2) - 1;
            --this.iN;
            return true;
        }
        --this.iL;
        --this.iN;
        return true;
    }

    private boolean fetchData(long l2) {
        h h2 = this.K.hc.a(this, l2);
        this.iO = h2.updateCount;
        if (h2.ej != null) {
            this.iK = h2.ej;
            this.iM = l2;
            this.iL = 0;
            return true;
        }
        return false;
    }

    public void do_setFetchDirection(int n2) {
        this.checkClosed();
        if (n2 != 1002 && n2 != 1000 && n2 != 1001) {
            DBError.ECJDBC_INVALID_CURSOR_MOVE_DIRECTION.throwException(new String[0]);
        }
        if (this.type == 1003 && n2 != 1000) {
            DBError.ECJDBC_FORWORD_ONLY_RESULTSET.throwException(new String[0]);
        }
        this.iU = n2;
    }

    public int do_getFetchDirection() {
        this.checkClosed();
        return this.iU;
    }

    public void do_setFetchSize(int n2) {
        this.checkClosed();
        if (n2 < 0 || this.iG != null && this.iG.kF > 0L && (long)n2 > this.iG.kF) {
            DBError.ECJDBC_INVALUID_ROW_NUMBER.throwException(new String[0]);
        }
        this.iV = n2;
    }

    public int do_getFetchSize() {
        this.checkClosed();
        return ConvertUtil.toInt(this.iV);
    }

    public int do_getType() {
        this.checkClosed();
        return this.type;
    }

    public int do_getConcurrency() {
        this.checkClosed();
        return this.iS;
    }

    public DmdbStatement do_getStatement() {
        this.checkClosed();
        return this.iG;
    }

    private byte[] getColumnData(int n2) {
        this.checkClosed();
        this.checkCurrentRow();
        this.checkColumnIndex(n2);
        byte[] byArray = this.iK[this.iL][n2];
        this.gl = byArray == null;
        this.iI[n2 - 1].ax = this.iQ;
        return byArray;
    }

    private void checkColumnIndex(int n2) {
        if (n2 < 1 || n2 > this.iI.length) {
            DBError.ECJDBC_INVALID_SEQUENCE_NUMBER.throwException(new String[0]);
        }
    }

    private void checkCurrentRow() {
        if (this.iO == 0L || this.do_isBeforeFirst() || this.do_isAfterLast()) {
            DBError.ECJDBC_CURSOR_NOT_IN_RESULTSET.throwException(new String[0]);
        }
    }

    public boolean do_wasNull() {
        this.checkClosed();
        return this.gl;
    }

    public String do_getString(int n2) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.f(byArray, this.iI[n2 - 1], this.K) : null;
    }

    public boolean do_getBoolean(int n2) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null && a.g(byArray, this.iI[n2 - 1], this.K);
    }

    public byte do_getByte(int n2) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.h(byArray, this.iI[n2 - 1], this.K) : (byte)0;
    }

    public short do_getShort(int n2) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.i(byArray, this.iI[n2 - 1], this.K) : (short)0;
    }

    public int do_getInt(int n2) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.j(byArray, this.iI[n2 - 1], this.K) : 0;
    }

    public long do_getLong(int n2) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.k(byArray, this.iI[n2 - 1], this.K) : 0L;
    }

    public float do_getFloat(int n2) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.l(byArray, this.iI[n2 - 1], this.K) : 0.0f;
    }

    public double do_getDouble(int n2) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.m(byArray, this.iI[n2 - 1], this.K) : 0.0;
    }

    public BigDecimal do_getBigDecimal(int n2, int n3) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.a(byArray, this.iI[n2 - 1], this.K, n3) : null;
    }

    public byte[] do_getBytes(int n2) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.o(byArray, this.iI[n2 - 1], this.K) : null;
    }

    public Date do_getDate(int n2) {
        return this.do_getDate(n2, null);
    }

    public Time do_getTime(int n2) {
        return this.do_getTime(n2, null);
    }

    public Timestamp do_getTimestamp(int n2) {
        return this.do_getTimestamp(n2, null);
    }

    public DmdbInputStream do_getAsciiStream(int n2) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.q(byArray, this.iI[n2 - 1], this.K) : null;
    }

    public UtilBinaryToUnicodeInputStream do_getUnicodeStream(int n2) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.r(byArray, this.iI[n2 - 1], this.K) : null;
    }

    public DmdbInputStream do_getBinaryStream(int n2) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.s(byArray, this.iI[n2 - 1], this.K) : null;
    }

    public Object do_getObject(int n2) {
        return this.do_getObject(n2, this.K.do_getTypeMap());
    }

    public DmdbReader do_getCharacterStream(int n2) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.t(byArray, this.iI[n2 - 1], this.K) : null;
    }

    public BigDecimal do_getBigDecimal(int n2) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.n(byArray, this.iI[n2 - 1], this.K) : null;
    }

    public Object do_getObject(int n2, Map map) {
        this.checkColumnIndex(n2);
        Object object = null;
        d d2 = this.iI[n2 - 1];
        switch (d2.type) {
            case 3: 
            case 13: {
                object = this.do_getBoolean(n2);
                break;
            }
            case 5: {
                object = this.do_getByte(n2);
                break;
            }
            case 6: {
                object = this.do_getShort(n2);
                break;
            }
            case 7: {
                object = this.do_getInt(n2);
                break;
            }
            case 8: {
                object = this.do_getLong(n2);
                break;
            }
            case 9: {
                object = this.do_getBigDecimal(n2);
                break;
            }
            case 10: {
                object = Float.valueOf(this.do_getFloat(n2));
                break;
            }
            case 11: {
                object = this.do_getDouble(n2);
                break;
            }
            case 14: {
                object = this.getDate(n2);
                break;
            }
            case 15: {
                object = this.getTime(n2);
                break;
            }
            case 16: {
                object = this.getTimestamp(n2);
                break;
            }
            case 22: 
            case 23: {
                object = this.getTIMESTAMP(n2);
                break;
            }
            case 17: 
            case 18: {
                object = this.do_getBytes(n2);
                break;
            }
            case 12: {
                if (DmdbType.isComplexType(d2.type, d2.scale)) {
                    byte[] byArray = this.getColumnData(n2);
                    object = byArray != null ? a.b(byArray, d2, this.K, map) : null;
                    break;
                }
                if (StringUtil.equalsIgnoreCase(d2.ao, "LONGVARBINARY")) {
                    object = this.do_getBytes(n2);
                    break;
                }
                object = this.do_getBlob(n2);
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                object = this.do_getString(n2);
                if (object == null || !DmdbType.isBFile(d2.type, d2.prec, d2.scale)) break;
                object = new DmdbBFile((String)object);
                break;
            }
            case 19: {
                object = StringUtil.equalsIgnoreCase(d2.ao, "LONGVARCHAR") ? this.do_getString(n2) : this.do_getClob(n2);
                break;
            }
            case 20: {
                object = this.getINTERVALYM(n2);
                break;
            }
            case 21: {
                object = this.getINTERVALDT(n2);
                break;
            }
            case 117: 
            case 119: 
            case 121: 
            case 122: {
                byte[] byArray = this.getColumnData(n2);
                object = byArray != null ? a.b(byArray, d2, this.K, map) : null;
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
            }
        }
        return this.gl ? null : object;
    }

    public Ref do_getRef(int n2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    public DmdbBlob do_getBlob(int n2) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.u(byArray, this.iI[n2 - 1], this.K) : null;
    }

    public DmdbClob do_getClob(int n2) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.v(byArray, this.iI[n2 - 1], this.K) : null;
    }

    public DmdbArray do_getArray(int n2) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.w(byArray, this.iI[n2 - 1], this.K) : null;
    }

    public Date do_getDate(int n2, Calendar calendar) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.a(byArray, this.iI[n2 - 1], this.K, calendar) : null;
    }

    public Time do_getTime(int n2, Calendar calendar) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.b(byArray, this.iI[n2 - 1], this.K, calendar) : null;
    }

    public Timestamp do_getTimestamp(int n2, Calendar calendar) {
        byte[] byArray = this.getColumnData(n2);
        return byArray != null ? a.c(byArray, this.iI[n2 - 1], this.K, calendar) : null;
    }

    public URL do_getURL(int n2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    public int do_findColumn(String string) {
        Integer n2;
        this.checkClosed();
        if (StringUtil.isEmpty(string)) {
            DBError.ECJDBC_INVALID_COLUMN_NAME.throwException(new String[0]);
        }
        if ((n2 = (Integer)this.iJ.get(this.K.connection_property_ignoreCase ? string.toLowerCase() : string)) == null) {
            DBError.ECJDBC_INVALID_COLUMN_NAME.throwException(new String[0]);
        }
        return n2;
    }

    public String do_getString(String string) {
        return this.do_getString(this.do_findColumn(string));
    }

    public boolean do_getBoolean(String string) {
        return this.do_getBoolean(this.do_findColumn(string));
    }

    public byte do_getByte(String string) {
        return this.do_getByte(this.do_findColumn(string));
    }

    public short do_getShort(String string) {
        return this.do_getShort(this.do_findColumn(string));
    }

    public int do_getInt(String string) {
        return this.do_getInt(this.do_findColumn(string));
    }

    public long do_getLong(String string) {
        return this.do_getLong(this.do_findColumn(string));
    }

    public float do_getFloat(String string) {
        return this.do_getFloat(this.do_findColumn(string));
    }

    public double do_getDouble(String string) {
        return this.do_getDouble(this.do_findColumn(string));
    }

    public BigDecimal do_getBigDecimal(String string, int n2) {
        return this.do_getBigDecimal(this.do_findColumn(string), n2);
    }

    public byte[] do_getBytes(String string) {
        return this.do_getBytes(this.do_findColumn(string));
    }

    public Date do_getDate(String string) {
        return this.do_getDate(this.do_findColumn(string));
    }

    public Time do_getTime(String string) {
        return this.do_getTime(this.do_findColumn(string));
    }

    public Timestamp do_getTimestamp(String string) {
        return this.do_getTimestamp(this.do_findColumn(string));
    }

    public DmdbInputStream do_getAsciiStream(String string) {
        return this.do_getAsciiStream(this.do_findColumn(string));
    }

    public UtilBinaryToUnicodeInputStream do_getUnicodeStream(String string) {
        return this.do_getUnicodeStream(this.do_findColumn(string));
    }

    public DmdbInputStream do_getBinaryStream(String string) {
        return this.do_getBinaryStream(this.do_findColumn(string));
    }

    public Object do_getObject(String string) {
        return this.do_getObject(this.do_findColumn(string));
    }

    public DmdbReader do_getCharacterStream(String string) {
        return this.do_getCharacterStream(this.do_findColumn(string));
    }

    public BigDecimal do_getBigDecimal(String string) {
        return this.do_getBigDecimal(this.do_findColumn(string));
    }

    public Object do_getObject(String string, Map map) {
        return this.do_getObject(this.do_findColumn(string), map);
    }

    public Ref do_getRef(String string) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    public DmdbBlob do_getBlob(String string) {
        return this.do_getBlob(this.do_findColumn(string));
    }

    public DmdbClob do_getClob(String string) {
        return this.do_getClob(this.do_findColumn(string));
    }

    public DmdbArray do_getArray(String string) {
        return this.do_getArray(this.do_findColumn(string));
    }

    public Date do_getDate(String string, Calendar calendar) {
        return this.do_getDate(this.do_findColumn(string), calendar);
    }

    public Time do_getTime(String string, Calendar calendar) {
        return this.do_getTime(this.do_findColumn(string), calendar);
    }

    public Timestamp do_getTimestamp(String string, Calendar calendar) {
        return this.do_getTimestamp(this.do_findColumn(string), calendar);
    }

    public URL do_getURL(String string) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    public boolean do_rowUpdated() {
        this.checkClosed();
        return false;
    }

    public boolean do_rowInserted() {
        this.checkClosed();
        return false;
    }

    public boolean do_rowDeleted() {
        this.checkClosed();
        return false;
    }

    public void do_insertRow() {
        this.checkClosed();
        this.checkUpdatable();
        if (this.jb != this.iX) {
            DBError.ECJDBC_RESULTSET_NOT_IN_INSERT_STATUS.throwException(new String[0]);
        }
        if (!this.checkColumnBindes()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("insert into ");
        stringBuilder.append("\"").append(StringUtil.processDoubleQuoteOfName(this.iI[0].schemaName)).append("\"");
        stringBuilder.append(".\"").append(StringUtil.processDoubleQuoteOfName(this.iI[0].tableName)).append("\" ( ");
        StringBuilder stringBuilder2 = new StringBuilder();
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.iI.length) {
            if (this.iY[n3]) {
                if (n2 > 0) {
                    stringBuilder.append(" , ");
                    stringBuilder2.append(" , ");
                }
                stringBuilder.append("\"").append(StringUtil.processDoubleQuoteOfName(this.iI[n3].name)).append("\"");
                stringBuilder2.append(" ? ");
                ++n2;
            }
            ++n3;
        }
        stringBuilder.append(") values(").append((CharSequence)stringBuilder2).append(")");
        DriverUtil.executePrepare(this.K, stringBuilder.toString(), this.iX, this.iY);
        this.clearInsertRow();
    }

    public void do_updateRow() {
        this.checkClosed();
        this.checkUpdatable();
        if (this.jb == this.iX) {
            DBError.ECJDBC_RESULTSET_IN_INSERT_STATUS.throwException(new String[0]);
        }
        this.checkCurrentRow();
        if (!this.checkColumnBindes()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("update ");
        stringBuilder.append("\"").append(StringUtil.processDoubleQuoteOfName(this.iI[0].schemaName)).append("\"");
        stringBuilder.append(".\"").append(StringUtil.processDoubleQuoteOfName(this.iI[0].tableName)).append("\" ");
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.iZ.length) {
            if (this.ja[n3]) {
                stringBuilder.append(n2 == 0 ? "set " : ", ");
                stringBuilder.append("\"").append(StringUtil.processDoubleQuoteOfName(this.iI[n3].name)).append("\" = ? ");
                ++n2;
            }
            ++n3;
        }
        stringBuilder.append(" where current of \"").append(StringUtil.processDoubleQuoteOfName(this.do_getCursorName())).append("\"");
        DriverUtil.executePrepareCursorUpdate(this.K, stringBuilder.toString(), this.iZ, this.ja, this.iN);
        this.clearUpdateRow();
    }

    public void do_deleteRow() {
        this.checkClosed();
        this.checkUpdatable();
        if (this.jb == this.iX) {
            DBError.ECJDBC_RESULTSET_IN_INSERT_STATUS.throwException(new String[0]);
        }
        this.checkCurrentRow();
        String string = "DELETE FROM \"" + StringUtil.processDoubleQuoteOfName(this.iI[0].schemaName) + "\".\"" + StringUtil.processDoubleQuoteOfName(this.iI[0].tableName) + "\" WHERE CURRENT OF \"" + StringUtil.processDoubleQuoteOfName(this.do_getCursorName()) + "\"";
        DriverUtil.executeCursorUpdate(this.K, string, this.iN);
        this.clearUpdateRow();
    }

    public void do_refreshRow() {
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwException(new String[0]);
        }
        if (this.jb == this.iX) {
            DBError.ECJDBC_RESULTSET_IN_INSERT_STATUS.throwException(new String[0]);
        }
        this.clearUpdateRow();
    }

    public void do_cancelRowUpdates() {
        this.checkClosed();
        this.checkUpdatable();
        this.clearUpdateRow();
        this.clearInsertRow();
    }

    public void do_moveToInsertRow() {
        this.checkClosed();
        this.checkUpdatable();
        if (this.iX == null) {
            this.iX = new j[this.iI.length];
            this.iY = new boolean[this.iI.length];
        }
        this.jb = this.iX;
        this.jc = this.iY;
    }

    public void do_moveToCurrentRow() {
        this.checkClosed();
        this.checkUpdatable();
        this.jb = this.iZ;
        this.jc = this.ja;
    }

    private void updateColumn(int n2, Object object) {
        this.checkClosed();
        this.checkUpdatable();
        this.checkColumnIndex(n2);
        if (this.jb != this.iX) {
            this.checkCurrentRow();
        }
        if (object == null) {
            this.checkColumnNullable(n2);
        }
        this.jb[n2 - 1] = new j(object);
        this.jc[n2 - 1] = true;
    }

    private void updateColumn(int n2, Object object, int n3) {
        this.updateColumn(n2, object);
        this.jb[n2 - 1].eK = n3;
    }

    private void updateColumn(int n2, Object object, int n3, long l2) {
        this.updateColumn(n2, object, n3);
        this.jb[n2 - 1].eL = l2;
    }

    public void do_updateNull(int n2) {
        this.updateColumn(n2, null);
    }

    public void do_updateBoolean(int n2, boolean bl) {
        this.updateColumn(n2, bl);
    }

    public void do_updateByte(int n2, byte by) {
        this.updateColumn(n2, by);
    }

    public void do_updateShort(int n2, short s2) {
        this.updateColumn(n2, s2);
    }

    public void do_updateInt(int n2, int n3) {
        this.updateColumn(n2, n3);
    }

    public void do_updateLong(int n2, long l2) {
        this.updateColumn(n2, l2);
    }

    public void do_updateFloat(int n2, float f2) {
        this.updateColumn(n2, Float.valueOf(f2));
    }

    public void do_updateDouble(int n2, double d2) {
        this.updateColumn(n2, d2);
    }

    public void do_updateBigDecimal(int n2, BigDecimal bigDecimal) {
        this.updateColumn(n2, bigDecimal);
    }

    public void do_updateString(int n2, String string) {
        this.updateColumn(n2, string);
    }

    public void do_updateBytes(int n2, byte[] byArray) {
        this.updateColumn(n2, byArray);
    }

    public void do_updateDate(int n2, Date date) {
        this.updateColumn(n2, date);
    }

    public void do_updateTime(int n2, Time time) {
        this.updateColumn(n2, time);
    }

    public void do_updateTimestamp(int n2, Timestamp timestamp) {
        this.updateColumn(n2, timestamp);
    }

    public void do_updateAsciiStream(int n2, InputStream inputStream, int n3) {
        this.updateColumn(n2, inputStream, 2004, n3);
    }

    public void do_updateBinaryStream(int n2, InputStream inputStream, int n3) {
        this.updateColumn(n2, inputStream, 2004, n3);
    }

    public void do_updateCharacterStream(int n2, Reader reader, int n3) {
        this.updateColumn(n2, reader, 2005, n3);
    }

    public void do_updateObject(int n2, Object object, int n3) {
        this.updateColumn(n2, object, 1111, n3);
    }

    public void do_updateObject(int n2, Object object) {
        this.updateColumn(n2, object);
    }

    public void do_updateRef(int n2, Ref ref) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_updateBlob(int n2, Blob blob) {
        this.updateColumn(n2, blob);
    }

    public void do_updateClob(int n2, Clob clob) {
        this.updateColumn(n2, clob);
    }

    public void do_updateArray(int n2, Array array) {
        this.updateColumn(n2, array);
    }

    public void do_updateNull(String string) {
        this.do_updateNull(this.do_findColumn(string));
    }

    public void do_updateBoolean(String string, boolean bl) {
        this.do_updateBoolean(this.do_findColumn(string), bl);
    }

    public void do_updateByte(String string, byte by) {
        this.do_updateByte(this.do_findColumn(string), by);
    }

    public void do_updateShort(String string, short s2) {
        this.do_updateShort(this.do_findColumn(string), s2);
    }

    public void do_updateInt(String string, int n2) {
        this.do_updateInt(this.do_findColumn(string), n2);
    }

    public void do_updateLong(String string, long l2) {
        this.do_updateLong(this.do_findColumn(string), l2);
    }

    public void do_updateFloat(String string, float f2) {
        this.do_updateFloat(this.do_findColumn(string), f2);
    }

    public void do_updateDouble(String string, double d2) {
        this.do_updateDouble(this.do_findColumn(string), d2);
    }

    public void do_updateBigDecimal(String string, BigDecimal bigDecimal) {
        this.do_updateBigDecimal(this.do_findColumn(string), bigDecimal);
    }

    public void do_updateString(String string, String string2) {
        this.do_updateString(this.do_findColumn(string), string2);
    }

    public void do_updateBytes(String string, byte[] byArray) {
        this.do_updateBytes(this.do_findColumn(string), byArray);
    }

    public void do_updateDate(String string, Date date) {
        this.do_updateDate(this.do_findColumn(string), date);
    }

    public void do_updateTime(String string, Time time) {
        this.do_updateTime(this.do_findColumn(string), time);
    }

    public void do_updateTimestamp(String string, Timestamp timestamp) {
        this.do_updateTimestamp(this.do_findColumn(string), timestamp);
    }

    public void do_updateAsciiStream(String string, InputStream inputStream, int n2) {
        this.do_updateAsciiStream(this.do_findColumn(string), inputStream, n2);
    }

    public void do_updateBinaryStream(String string, InputStream inputStream, int n2) {
        this.do_updateBinaryStream(this.do_findColumn(string), inputStream, n2);
    }

    public void do_updateCharacterStream(String string, Reader reader, int n2) {
        this.do_updateCharacterStream(this.do_findColumn(string), reader, n2);
    }

    public void do_updateObject(String string, Object object, int n2) {
        this.do_updateObject(this.do_findColumn(string), object, n2);
    }

    public void do_updateObject(String string, Object object) {
        this.do_updateObject(this.do_findColumn(string), object);
    }

    public void do_updateRef(String string, Ref ref) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_updateBlob(String string, Blob blob) {
        this.do_updateBlob(this.do_findColumn(string), blob);
    }

    public void do_updateClob(String string, Clob clob) {
        this.do_updateClob(this.do_findColumn(string), clob);
    }

    public void do_updateArray(String string, Array array) {
        this.do_updateArray(this.do_findColumn(string), array);
    }

    private void checkUpdatable() {
        if (!this.iP || this.iS != 1008) {
            DBError.ECJDBC_RESULTSET_IS_READ_ONLY.throwException(new String[0]);
        }
    }

    private void checkColumnNullable(int n2) {
        if (!this.iI[n2 - 1].ap) {
            DBError.ECJDBC_NOT_ALLOW_NULL.throwException(new String[0]);
        }
    }

    private void clearUpdateRow() {
        if (this.iZ == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.iZ.length) {
            this.iZ[n2] = null;
            this.ja[n2] = false;
            ++n2;
        }
    }

    private void clearInsertRow() {
        if (this.iX == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.iX.length) {
            this.iX[n2] = null;
            this.iY[n2] = false;
            ++n2;
        }
    }

    private boolean checkColumnBindes() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.jb.length) {
            if (this.jc[n3]) {
                ++n2;
            }
            ++n3;
        }
        return n2 > 0;
    }

    public int do_getHoldability() {
        return 1;
    }

    public void do_updateNString(int n2, String string) {
        this.do_updateString(n2, string);
    }

    public void do_updateNString(String string, String string2) {
        this.do_updateString(string, string2);
    }

    public String do_getNString(int n2) {
        return this.do_getString(n2);
    }

    public String do_getNString(String string) {
        return this.do_getString(string);
    }

    public DmdbReader do_getNCharacterStream(int n2) {
        return this.do_getCharacterStream(n2);
    }

    public DmdbReader do_getNCharacterStream(String string) {
        return this.do_getCharacterStream(string);
    }

    public void do_updateNCharacterStream(int n2, Reader reader, long l2) {
        this.do_updateCharacterStream(n2, reader, l2);
    }

    public void do_updateNCharacterStream(String string, Reader reader, long l2) {
        this.do_updateCharacterStream(string, reader, l2);
    }

    public void do_updateNClob(int n2, Reader reader, long l2) {
        this.do_updateClob(n2, reader, l2);
    }

    public void do_updateNClob(String string, Reader reader, long l2) {
        this.do_updateClob(string, reader, l2);
    }

    public void do_updateNCharacterStream(int n2, Reader reader) {
        this.do_updateCharacterStream(n2, reader);
    }

    public void do_updateNCharacterStream(String string, Reader reader) {
        this.do_updateCharacterStream(string, reader);
    }

    public void do_updateNClob(int n2, Reader reader) {
        this.do_updateClob(n2, reader);
    }

    public void do_updateNClob(String string, Reader reader) {
        this.do_updateClob(string, reader);
    }

    public RowId do_getRowId(int n2) {
        long l2 = this.do_getLong(n2);
        String string = this.iI[n2 - 1].schemaName;
        String string2 = this.iI[n2 - 1].tableName;
        return new DmdbRowId(l2, string, string2);
    }

    public RowId do_getRowId(String string) {
        return this.do_getRowId(this.do_findColumn(string));
    }

    public void do_updateRowId(int n2, RowId rowId) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_updateRowId(String string, RowId rowId) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public boolean do_isClosed() {
        return this.closed;
    }

    public void do_updateNClob(int n2, NClob nClob) {
        this.do_updateClob(n2, (Clob)nClob);
    }

    public void do_updateNClob(String string, NClob nClob) {
        this.do_updateClob(string, (Clob)nClob);
    }

    public NClob do_getNClob(int n2) {
        return (NClob)((Object)this.do_getClob(n2));
    }

    public NClob do_getNClob(String string) {
        return (NClob)((Object)this.do_getClob(string));
    }

    public SQLXML do_getSQLXML(int n2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    public SQLXML do_getSQLXML(String string) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    public void do_updateSQLXML(int n2, SQLXML sQLXML) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_updateSQLXML(String string, SQLXML sQLXML) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_updateAsciiStream(int n2, InputStream inputStream, long l2) {
        this.updateColumn(n2, inputStream, 2004, l2);
    }

    public void do_updateBinaryStream(int n2, InputStream inputStream, long l2) {
        this.updateColumn(n2, inputStream, 2004, l2);
    }

    public void do_updateCharacterStream(int n2, Reader reader, long l2) {
        this.updateColumn(n2, reader, 2005, l2);
    }

    public void do_updateAsciiStream(String string, InputStream inputStream, long l2) {
        this.do_updateBinaryStream(this.do_findColumn(string), inputStream, l2);
    }

    public void do_updateBinaryStream(String string, InputStream inputStream, long l2) {
        this.do_updateBinaryStream(this.do_findColumn(string), inputStream, l2);
    }

    public void do_updateCharacterStream(String string, Reader reader, long l2) {
        this.do_updateCharacterStream(this.do_findColumn(string), reader, l2);
    }

    public void do_updateBlob(int n2, InputStream inputStream, long l2) {
        this.updateColumn(n2, inputStream, 2004, l2);
    }

    public void do_updateBlob(String string, InputStream inputStream, long l2) {
        this.do_updateBlob(this.do_findColumn(string), inputStream, l2);
    }

    public void do_updateClob(int n2, Reader reader, long l2) {
        this.updateColumn(n2, reader, 2005, l2);
    }

    public void do_updateClob(String string, Reader reader, long l2) {
        this.do_updateClob(this.do_findColumn(string), reader, l2);
    }

    public void do_updateAsciiStream(int n2, InputStream inputStream) {
        this.updateColumn(n2, inputStream);
    }

    public void do_updateBinaryStream(int n2, InputStream inputStream) {
        this.updateColumn(n2, inputStream);
    }

    public void do_updateCharacterStream(int n2, Reader reader) {
        this.updateColumn(n2, reader);
    }

    public void do_updateAsciiStream(String string, InputStream inputStream) {
        this.do_updateAsciiStream(this.do_findColumn(string), inputStream);
    }

    public void do_updateBinaryStream(String string, InputStream inputStream) {
        this.do_updateBinaryStream(this.do_findColumn(string), inputStream);
    }

    public void do_updateCharacterStream(String string, Reader reader) {
        this.do_updateCharacterStream(this.do_findColumn(string), reader);
    }

    public void do_updateBlob(int n2, InputStream inputStream) {
        this.updateColumn(n2, inputStream);
    }

    public void do_updateBlob(String string, InputStream inputStream) {
        this.do_updateBlob(this.do_findColumn(string), inputStream);
    }

    public void do_updateClob(int n2, Reader reader) {
        this.updateColumn(n2, reader);
    }

    public void do_updateClob(String string, Reader reader) {
        this.do_updateClob(this.do_findColumn(string), reader);
    }

    public Object do_getObject(int n2, Class clazz) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    public Object do_getObject(String string, Class clazz) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    public void do_updateObject(int n2, Object object, SQLType sQLType, int n3) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_updateObject(String string, Object object, SQLType sQLType, int n2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_updateObject(int n2, Object object, SQLType sQLType) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_updateObject(String string, Object object, SQLType sQLType) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    private void checkConnection() {
        if (this.K == null) {
            DBError.ECJDBC_CONNECTION_CLOSED.throwException(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_next();
            }
            return this.filterChain.reset().ResultSet_next(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.K == null) {
            return;
        }
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_close();
            } else {
                this.filterChain.reset().ResultSet_close(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNull() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_wasNull();
            }
            return this.filterChain.reset().ResultSet_wasNull(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getString(n2);
            }
            return this.filterChain.reset().ResultSet_getString(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBoolean(n2);
            }
            return this.filterChain.reset().ResultSet_getBoolean(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getByte(n2);
            }
            return this.filterChain.reset().ResultSet_getByte(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getShort(n2);
            }
            return this.filterChain.reset().ResultSet_getShort(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getInt(n2);
            }
            return this.filterChain.reset().ResultSet_getInt(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getLong(n2);
            }
            return this.filterChain.reset().ResultSet_getLong(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int n2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getFloat(n2);
            }
            return this.filterChain.reset().ResultSet_getFloat(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int n2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getDouble(n2);
            }
            return this.filterChain.reset().ResultSet_getDouble(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2, int n3) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBigDecimal(n2, n3);
            }
            return this.filterChain.reset().ResultSet_getBigDecimal(this, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int n2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBytes(n2);
            }
            return this.filterChain.reset().ResultSet_getBytes(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getDate(n2);
            }
            return this.filterChain.reset().ResultSet_getDate(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTime(n2);
            }
            return this.filterChain.reset().ResultSet_getTime(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTimestamp(n2);
            }
            return this.filterChain.reset().ResultSet_getTimestamp(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int n2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getAsciiStream(n2);
            }
            return this.filterChain.reset().ResultSet_getAsciiStream(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(int n2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getUnicodeStream(n2);
            }
            return this.filterChain.reset().ResultSet_getUnicodeStream(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(int n2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBinaryStream(n2);
            }
            return this.filterChain.reset().ResultSet_getBinaryStream(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getString(string);
            }
            return this.filterChain.reset().ResultSet_getString(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBoolean(string);
            }
            return this.filterChain.reset().ResultSet_getBoolean(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getByte(string);
            }
            return this.filterChain.reset().ResultSet_getByte(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getShort(string);
            }
            return this.filterChain.reset().ResultSet_getShort(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getInt(string);
            }
            return this.filterChain.reset().ResultSet_getInt(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getLong(string);
            }
            return this.filterChain.reset().ResultSet_getLong(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getFloat(string);
            }
            return this.filterChain.reset().ResultSet_getFloat(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getDouble(string);
            }
            return this.filterChain.reset().ResultSet_getDouble(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(String string, int n2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBigDecimal(string, n2);
            }
            return this.filterChain.reset().ResultSet_getBigDecimal(this, string, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBytes(string);
            }
            return this.filterChain.reset().ResultSet_getBytes(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getDate(string);
            }
            return this.filterChain.reset().ResultSet_getDate(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTime(string);
            }
            return this.filterChain.reset().ResultSet_getTime(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTimestamp(string);
            }
            return this.filterChain.reset().ResultSet_getTimestamp(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getAsciiStream(string);
            }
            return this.filterChain.reset().ResultSet_getAsciiStream(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getUnicodeStream(string);
            }
            return this.filterChain.reset().ResultSet_getUnicodeStream(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBinaryStream(string);
            }
            return this.filterChain.reset().ResultSet_getBinaryStream(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getWarnings();
            }
            return this.filterChain.reset().ResultSet_getWarnings(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_clearWarnings();
            } else {
                this.filterChain.reset().ResultSet_clearWarnings(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCursorName() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCursorName();
            }
            return this.filterChain.reset().ResultSet_getCursorName(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getMetaData();
            }
            return this.filterChain.reset().ResultSet_getMetaData(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getObject(n2);
            }
            return this.filterChain.reset().ResultSet_getObject(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getObject(string);
            }
            return this.filterChain.reset().ResultSet_getObject(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findColumn(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_findColumn(string);
            }
            return this.filterChain.reset().ResultSet_findColumn(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int n2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCharacterStream(n2);
            }
            return this.filterChain.reset().ResultSet_getCharacterStream(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCharacterStream(string);
            }
            return this.filterChain.reset().ResultSet_getCharacterStream(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBigDecimal(n2);
            }
            return this.filterChain.reset().ResultSet_getBigDecimal(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBigDecimal(string);
            }
            return this.filterChain.reset().ResultSet_getBigDecimal(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBeforeFirst() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_isBeforeFirst();
            }
            return this.filterChain.reset().ResultSet_isBeforeFirst(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfterLast() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_isAfterLast();
            }
            return this.filterChain.reset().ResultSet_isAfterLast(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirst() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_isFirst();
            }
            return this.filterChain.reset().ResultSet_isFirst(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLast() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_isLast();
            }
            return this.filterChain.reset().ResultSet_isLast(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_beforeFirst();
            } else {
                this.filterChain.reset().ResultSet_beforeFirst(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_afterLast();
            } else {
                this.filterChain.reset().ResultSet_afterLast(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_first();
            }
            return this.filterChain.reset().ResultSet_first(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_last();
            }
            return this.filterChain.reset().ResultSet_last(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getRow();
            }
            return this.filterChain.reset().ResultSet_getRow(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean absolute(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_absolute(n2);
            }
            return this.filterChain.reset().ResultSet_absolute(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean relative(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_relative(n2);
            }
            return this.filterChain.reset().ResultSet_relative(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean previous() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_previous();
            }
            return this.filterChain.reset().ResultSet_previous(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int n2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setFetchDirection(n2);
            } else {
                this.filterChain.reset().ResultSet_setFetchDirection(this, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchDirection() {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getFetchDirection();
            }
            return this.filterChain.reset().ResultSet_getFetchDirection(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int n2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setFetchSize(n2);
            } else {
                this.filterChain.reset().ResultSet_setFetchSize(this, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getFetchSize();
            }
            return this.filterChain.reset().ResultSet_getFetchSize(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getType() {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getType();
            }
            return this.filterChain.reset().ResultSet_getType(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConcurrency() {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getConcurrency();
            }
            return this.filterChain.reset().ResultSet_getConcurrency(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rowUpdated() {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_rowUpdated();
            }
            return this.filterChain.reset().ResultSet_rowUpdated(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rowInserted() {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_rowInserted();
            }
            return this.filterChain.reset().ResultSet_rowInserted(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rowDeleted() {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_rowDeleted();
            }
            return this.filterChain.reset().ResultSet_rowDeleted(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNull(int n2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNull(n2);
            } else {
                this.filterChain.reset().ResultSet_updateNull(this, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBoolean(int n2, boolean bl) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBoolean(n2, bl);
            } else {
                this.filterChain.reset().ResultSet_updateBoolean(this, n2, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateByte(int n2, byte by) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateByte(n2, by);
            } else {
                this.filterChain.reset().ResultSet_updateByte(this, n2, by);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateShort(int n2, short s2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateShort(n2, s2);
            } else {
                this.filterChain.reset().ResultSet_updateShort(this, n2, s2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInt(int n2, int n3) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateInt(n2, n3);
            } else {
                this.filterChain.reset().ResultSet_updateInt(this, n2, n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLong(int n2, long l2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateLong(n2, l2);
            } else {
                this.filterChain.reset().ResultSet_updateLong(this, n2, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFloat(int n2, float f2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateFloat(n2, f2);
            } else {
                this.filterChain.reset().ResultSet_updateFloat(this, n2, f2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDouble(int n2, double d2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateDouble(n2, d2);
            } else {
                this.filterChain.reset().ResultSet_updateDouble(this, n2, d2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBigDecimal(n2, bigDecimal);
            } else {
                this.filterChain.reset().ResultSet_updateBigDecimal(this, n2, bigDecimal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateString(int n2, String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateString(n2, string);
            } else {
                this.filterChain.reset().ResultSet_updateString(this, n2, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBytes(int n2, byte[] byArray) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBytes(n2, byArray);
            } else {
                this.filterChain.reset().ResultSet_updateBytes(this, n2, byArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDate(int n2, Date date) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateDate(n2, date);
            } else {
                this.filterChain.reset().ResultSet_updateDate(this, n2, date);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTime(int n2, Time time) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateTime(n2, time);
            } else {
                this.filterChain.reset().ResultSet_updateTime(this, n2, time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateTimestamp(n2, timestamp);
            } else {
                this.filterChain.reset().ResultSet_updateTimestamp(this, n2, timestamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateAsciiStream(n2, inputStream, n3);
            } else {
                this.filterChain.reset().ResultSet_updateAsciiStream(this, n2, inputStream, n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBinaryStream(n2, inputStream, n3);
            } else {
                this.filterChain.reset().ResultSet_updateBinaryStream(this, n2, inputStream, n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateCharacterStream(n2, reader, n3);
            } else {
                this.filterChain.reset().ResultSet_updateCharacterStream(this, n2, reader, n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int n2, Object object, int n3) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateObject(n2, object, n3);
            } else {
                this.filterChain.reset().ResultSet_updateObject(this, n2, object, n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int n2, Object object) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateObject(n2, object);
            } else {
                this.filterChain.reset().ResultSet_updateObject(this, n2, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNull(String string) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNull(string);
            } else {
                this.filterChain.reset().ResultSet_updateNull(this, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBoolean(String string, boolean bl) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBoolean(string, bl);
            } else {
                this.filterChain.reset().ResultSet_updateBoolean(this, string, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateByte(String string, byte by) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateByte(string, by);
            } else {
                this.filterChain.reset().ResultSet_updateByte(this, string, by);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateShort(String string, short s2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateShort(string, s2);
            } else {
                this.filterChain.reset().ResultSet_updateShort(this, string, s2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInt(String string, int n2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateInt(string, n2);
            } else {
                this.filterChain.reset().ResultSet_updateInt(this, string, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLong(String string, long l2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateLong(string, l2);
            } else {
                this.filterChain.reset().ResultSet_updateLong(this, string, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFloat(String string, float f2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateFloat(string, f2);
            } else {
                this.filterChain.reset().ResultSet_updateFloat(this, string, f2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDouble(String string, double d2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateDouble(string, d2);
            } else {
                this.filterChain.reset().ResultSet_updateDouble(this, string, d2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBigDecimal(string, bigDecimal);
            } else {
                this.filterChain.reset().ResultSet_updateBigDecimal(this, string, bigDecimal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateString(String string, String string2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateString(string, string2);
            } else {
                this.filterChain.reset().ResultSet_updateString(this, string, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBytes(String string, byte[] byArray) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBytes(string, byArray);
            } else {
                this.filterChain.reset().ResultSet_updateBytes(this, string, byArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDate(String string, Date date) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateDate(string, date);
            } else {
                this.filterChain.reset().ResultSet_updateDate(this, string, date);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTime(String string, Time time) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateTime(string, time);
            } else {
                this.filterChain.reset().ResultSet_updateTime(this, string, time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTimestamp(String string, Timestamp timestamp) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateTimestamp(string, timestamp);
            } else {
                this.filterChain.reset().ResultSet_updateTimestamp(this, string, timestamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) {
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateAsciiStream(string, inputStream, n2);
            } else {
                this.filterChain.reset().ResultSet_updateAsciiStream(this, string, inputStream, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBinaryStream(string, inputStream, n2);
            } else {
                this.filterChain.reset().ResultSet_updateBinaryStream(this, string, inputStream, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateCharacterStream(string, reader, n2);
            } else {
                this.filterChain.reset().ResultSet_updateCharacterStream(this, string, reader, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(String string, Object object, int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateObject(string, object, n2);
            } else {
                this.filterChain.reset().ResultSet_updateObject(this, string, object, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(String string, Object object) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateObject(string, object);
            } else {
                this.filterChain.reset().ResultSet_updateObject(this, string, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRow() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_insertRow();
            } else {
                this.filterChain.reset().ResultSet_insertRow(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRow() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateRow();
            } else {
                this.filterChain.reset().ResultSet_updateRow(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRow() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_deleteRow();
            } else {
                this.filterChain.reset().ResultSet_deleteRow(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRow() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_refreshRow();
            } else {
                this.filterChain.reset().ResultSet_refreshRow(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelRowUpdates() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_cancelRowUpdates();
            } else {
                this.filterChain.reset().ResultSet_cancelRowUpdates(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToInsertRow() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_moveToInsertRow();
            } else {
                this.filterChain.reset().ResultSet_moveToInsertRow(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToCurrentRow() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_moveToCurrentRow();
            } else {
                this.filterChain.reset().ResultSet_moveToCurrentRow(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getStatement() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getStatement();
            }
            return this.filterChain.reset().ResultSet_getStatement(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n2, Map map) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getObject(n2, map);
            }
            return this.filterChain.reset().ResultSet_getObject(this, n2, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getRef(n2);
            }
            return this.filterChain.reset().ResultSet_getRef(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBlob(n2);
            }
            return this.filterChain.reset().ResultSet_getBlob(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getClob(n2);
            }
            return this.filterChain.reset().ResultSet_getClob(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getArray(n2);
            }
            return this.filterChain.reset().ResultSet_getArray(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String string, Map map) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getObject(string, map);
            }
            return this.filterChain.reset().ResultSet_getObject(this, string, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getRef(string);
            }
            return this.filterChain.reset().ResultSet_getRef(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBlob(string);
            }
            return this.filterChain.reset().ResultSet_getBlob(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getClob(string);
            }
            return this.filterChain.reset().ResultSet_getClob(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getArray(string);
            }
            return this.filterChain.reset().ResultSet_getArray(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2, Calendar calendar) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getDate(n2, calendar);
            }
            return this.filterChain.reset().ResultSet_getDate(this, n2, calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(String string, Calendar calendar) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getDate(string, calendar);
            }
            return this.filterChain.reset().ResultSet_getDate(this, string, calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2, Calendar calendar) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTime(n2, calendar);
            }
            return this.filterChain.reset().ResultSet_getTime(this, n2, calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(String string, Calendar calendar) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTime(string, calendar);
            }
            return this.filterChain.reset().ResultSet_getTime(this, string, calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTimestamp(n2, calendar);
            }
            return this.filterChain.reset().ResultSet_getTimestamp(this, n2, calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTimestamp(string, calendar);
            }
            return this.filterChain.reset().ResultSet_getTimestamp(this, string, calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getURL(n2);
            }
            return this.filterChain.reset().ResultSet_getURL(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getURL(string);
            }
            return this.filterChain.reset().ResultSet_getURL(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRef(int n2, Ref ref) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateRef(n2, ref);
            } else {
                this.filterChain.reset().ResultSet_updateRef(this, n2, ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRef(String string, Ref ref) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateRef(string, ref);
            } else {
                this.filterChain.reset().ResultSet_updateRef(this, string, ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int n2, Blob blob) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBlob(n2, blob);
            } else {
                this.filterChain.reset().ResultSet_updateBlob(this, n2, blob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(String string, Blob blob) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBlob(string, blob);
            } else {
                this.filterChain.reset().ResultSet_updateBlob(this, string, blob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int n2, Clob clob) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateClob(n2, clob);
            } else {
                this.filterChain.reset().ResultSet_updateClob(this, n2, clob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(String string, Clob clob) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateClob(string, clob);
            } else {
                this.filterChain.reset().ResultSet_updateClob(this, string, clob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateArray(int n2, Array array) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateArray(n2, array);
            } else {
                this.filterChain.reset().ResultSet_updateArray(this, n2, array);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateArray(String string, Array array) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateArray(string, array);
            } else {
                this.filterChain.reset().ResultSet_updateArray(this, string, array);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowId getRowId(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getRowId(n2);
            }
            return this.filterChain.reset().ResultSet_getRowId(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowId getRowId(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getRowId(string);
            }
            return this.filterChain.reset().ResultSet_getRowId(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRowId(int n2, RowId rowId) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateRowId(n2, rowId);
            } else {
                this.filterChain.reset().ResultSet_updateRowId(this, n2, rowId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRowId(String string, RowId rowId) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateRowId(string, rowId);
            } else {
                this.filterChain.reset().ResultSet_updateRowId(this, string, rowId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHoldability() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getHoldability();
            }
            return this.filterChain.reset().ResultSet_getHoldability(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_isClosed();
            }
            return this.filterChain.reset().ResultSet_isClosed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNString(int n2, String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNString(n2, string);
            } else {
                this.filterChain.reset().ResultSet_updateNString(this, n2, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNString(String string, String string2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNString(string, string2);
            } else {
                this.filterChain.reset().ResultSet_updateNString(this, string, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(int n2, NClob nClob) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNClob(n2, nClob);
            } else {
                this.filterChain.reset().ResultSet_updateNClob(this, n2, nClob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(String string, NClob nClob) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNClob(string, nClob);
            } else {
                this.filterChain.reset().ResultSet_updateNClob(this, string, nClob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob getNClob(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getNClob(n2);
            }
            return this.filterChain.reset().ResultSet_getNClob(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob getNClob(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getNClob(string);
            }
            return this.filterChain.reset().ResultSet_getNClob(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML getSQLXML(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSQLXML(n2);
            }
            return this.filterChain.reset().ResultSet_getSQLXML(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML getSQLXML(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSQLXML(string);
            }
            return this.filterChain.reset().ResultSet_getSQLXML(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateSQLXML(n2, sQLXML);
            } else {
                this.filterChain.reset().ResultSet_updateSQLXML(this, n2, sQLXML);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateSQLXML(string, sQLXML);
            } else {
                this.filterChain.reset().ResultSet_updateSQLXML(this, string, sQLXML);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getNString(n2);
            }
            return this.filterChain.reset().ResultSet_getNString(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getNString(string);
            }
            return this.filterChain.reset().ResultSet_getNString(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getNCharacterStream(n2);
            }
            return this.filterChain.reset().ResultSet_getNCharacterStream(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getNCharacterStream(string);
            }
            return this.filterChain.reset().ResultSet_getNCharacterStream(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNCharacterStream(n2, reader, l2);
            } else {
                this.filterChain.reset().ResultSet_updateNCharacterStream(this, n2, reader, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNCharacterStream(String string, Reader reader, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNCharacterStream(string, reader, l2);
            } else {
                this.filterChain.reset().ResultSet_updateNCharacterStream(this, string, reader, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateAsciiStream(n2, inputStream, l2);
            } else {
                this.filterChain.reset().ResultSet_updateAsciiStream(this, n2, inputStream, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBinaryStream(n2, inputStream, l2);
            } else {
                this.filterChain.reset().ResultSet_updateBinaryStream(this, n2, inputStream, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateCharacterStream(n2, reader, l2);
            } else {
                this.filterChain.reset().ResultSet_updateCharacterStream(this, n2, reader, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateAsciiStream(string, inputStream, l2);
            } else {
                this.filterChain.reset().ResultSet_updateAsciiStream(this, string, inputStream, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBinaryStream(string, inputStream, l2);
            } else {
                this.filterChain.reset().ResultSet_updateBinaryStream(this, string, inputStream, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(String string, Reader reader, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateCharacterStream(string, reader, l2);
            } else {
                this.filterChain.reset().ResultSet_updateCharacterStream(this, string, reader, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBlob(n2, inputStream, l2);
            } else {
                this.filterChain.reset().ResultSet_updateBlob(this, n2, inputStream, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(String string, InputStream inputStream, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBlob(string, inputStream, l2);
            } else {
                this.filterChain.reset().ResultSet_updateBlob(this, string, inputStream, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int n2, Reader reader, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateClob(n2, reader, l2);
            } else {
                this.filterChain.reset().ResultSet_updateClob(this, n2, reader, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(String string, Reader reader, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateClob(string, reader, l2);
            } else {
                this.filterChain.reset().ResultSet_updateClob(this, string, reader, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(int n2, Reader reader, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNClob(n2, reader, l2);
            } else {
                this.filterChain.reset().ResultSet_updateNClob(this, n2, reader, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(String string, Reader reader, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNClob(string, reader, l2);
            } else {
                this.filterChain.reset().ResultSet_updateNClob(this, string, reader, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNCharacterStream(int n2, Reader reader) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNCharacterStream(n2, reader);
            } else {
                this.filterChain.reset().ResultSet_updateNCharacterStream(this, n2, reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNCharacterStream(String string, Reader reader) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNCharacterStream(string, reader);
            } else {
                this.filterChain.reset().ResultSet_updateNCharacterStream(this, string, reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateAsciiStream(n2, inputStream);
            } else {
                this.filterChain.reset().ResultSet_updateAsciiStream(this, n2, inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBinaryStream(n2, inputStream);
            } else {
                this.filterChain.reset().ResultSet_updateBinaryStream(this, n2, inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(int n2, Reader reader) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateCharacterStream(n2, reader);
            } else {
                this.filterChain.reset().ResultSet_updateCharacterStream(this, n2, reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(String string, InputStream inputStream) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateAsciiStream(string, inputStream);
            } else {
                this.filterChain.reset().ResultSet_updateAsciiStream(this, string, inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(String string, InputStream inputStream) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBinaryStream(string, inputStream);
            } else {
                this.filterChain.reset().ResultSet_updateBinaryStream(this, string, inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(String string, Reader reader) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateCharacterStream(string, reader);
            } else {
                this.filterChain.reset().ResultSet_updateCharacterStream(this, string, reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int n2, InputStream inputStream) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBlob(n2, inputStream);
            } else {
                this.filterChain.reset().ResultSet_updateBlob(this, n2, inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(String string, InputStream inputStream) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBlob(string, inputStream);
            } else {
                this.filterChain.reset().ResultSet_updateBlob(this, string, inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int n2, Reader reader) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateClob(n2, reader);
            } else {
                this.filterChain.reset().ResultSet_updateClob(this, n2, reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(String string, Reader reader) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateClob(string, reader);
            } else {
                this.filterChain.reset().ResultSet_updateClob(this, string, reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(int n2, Reader reader) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNClob(n2, reader);
            } else {
                this.filterChain.reset().ResultSet_updateNClob(this, n2, reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(String string, Reader reader) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNClob(string, reader);
            } else {
                this.filterChain.reset().ResultSet_updateNClob(this, string, reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n2, Class clazz) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getObject(n2, clazz);
            }
            return this.filterChain.reset().ResultSet_getObject(this, n2, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String string, Class clazz) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getObject(string, clazz);
            }
            return this.filterChain.reset().ResultSet_getObject(this, string, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int n2, Object object, SQLType sQLType, int n3) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateObject(n2, object, sQLType, n3);
            } else {
                this.filterChain.reset().ResultSet_updateObject(this, n2, object, sQLType, n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(String string, Object object, SQLType sQLType, int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateObject(string, object, sQLType, n2);
            } else {
                this.filterChain.reset().ResultSet_updateObject(this, string, object, sQLType, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int n2, Object object, SQLType sQLType) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateObject(n2, object, sQLType);
            } else {
                this.filterChain.reset().ResultSet_updateObject(this, n2, object, sQLType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(String string, Object object, SQLType sQLType) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateObject(string, object, sQLType);
            } else {
                this.filterChain.reset().ResultSet_updateObject(this, string, object, sQLType);
            }
        }
    }

    public Object unwrap(Class clazz) {
        return clazz.cast(this);
    }

    public boolean isWrapperFor(Class clazz) {
        return clazz.isInstance(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmdbIntervalYM getINTERVALYM(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            byte[] byArray = this.getColumnData(n2);
            return byArray != null ? new DmdbIntervalYM(byArray) : null;
        }
    }

    public DmdbIntervalYM getINTERVALYM(String string) {
        return this.getINTERVALYM(this.do_findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmdbIntervalDT getINTERVALDT(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            byte[] byArray = this.getColumnData(n2);
            return byArray != null ? new DmdbIntervalDT(byArray) : null;
        }
    }

    public DmdbIntervalDT getINTERVALDT(String string) {
        return this.getINTERVALDT(this.do_findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmdbTimestamp getTIMESTAMP(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            byte[] byArray = this.getColumnData(n2);
            return byArray != null ? a.p(byArray, this.iI[n2 - 1], this.K) : null;
        }
    }

    public DmdbTimestamp getTIMESTAMP(String string) {
        return this.getTIMESTAMP(this.do_findColumn(string));
    }

    public void updateINTERVALYM(int n2, DmdbIntervalYM dmdbIntervalYM) {
        this.updateColumn(n2, dmdbIntervalYM);
    }

    public void updateINTERVALYM(String string, DmdbIntervalYM dmdbIntervalYM) {
        this.updateINTERVALYM(this.do_findColumn(string), dmdbIntervalYM);
    }

    public void updateINTERVALDT(int n2, DmdbIntervalDT dmdbIntervalDT) {
        this.updateColumn(n2, dmdbIntervalDT);
    }

    public void updateINTERVALDT(String string, DmdbIntervalDT dmdbIntervalDT) {
        this.updateINTERVALDT(this.do_findColumn(string), dmdbIntervalDT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getRowCount() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            this.checkClosed();
            if (this.iO != Long.MAX_VALUE) {
                return this.iO;
            }
            if (this.type == 1003) {
                return -1L;
            }
            return this.K.hc.a(this);
        }
    }
}

