/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.b.h;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbResultSetKey;
import dm.jdbc.driver.DmdbStatement;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DmdbResultSetCachePool {
    static Map jh = null;
    static List ji = null;
    static long jj;

    static {
        jh = Collections.synchronizedMap(new HashMap(100));
        ji = Collections.synchronizedList(new LinkedList());
        jj = 0L;
    }

    private static long removeLast() {
        int n2 = ji.size();
        if (n2 == 0) {
            return 0L;
        }
        DmdbResultSetKey dmdbResultSetKey = (DmdbResultSetKey)ji.remove(n2 - 1);
        if (dmdbResultSetKey == null) {
            return 0L;
        }
        DmdbResultSetCache dmdbResultSetCache = (DmdbResultSetCache)jh.remove(dmdbResultSetKey);
        if (dmdbResultSetCache == null) {
            return 0L;
        }
        return dmdbResultSetCache.getDataLen();
    }

    private static void refreshKeyList(DmdbResultSetKey dmdbResultSetKey) {
        ji.remove(dmdbResultSetKey);
        ji.add(0, dmdbResultSetKey);
    }

    public static void addResultSet(DmdbStatement dmdbStatement, String string, h h2) {
        DmdbConnection dmdbConnection = dmdbStatement.K;
        long l2 = h2 == null ? 0L : h2.ek;
        long l3 = dmdbConnection.connection_property_rsCacheSize * 1024 * 1024;
        while (jj + l2 > l3) {
            if (jj == 0L) {
                return;
            }
            jj -= DmdbResultSetCachePool.removeLast();
        }
        DmdbResultSetKey dmdbResultSetKey = new DmdbResultSetKey(dmdbConnection.gF, dmdbConnection.gz, string, dmdbStatement);
        DmdbResultSetCachePool.refreshKeyList(dmdbResultSetKey);
        DmdbResultSetCache dmdbResultSetCache = new DmdbResultSetCache(h2);
        jh.put(dmdbResultSetKey, dmdbResultSetCache);
        jj += l2;
    }

    public static DmdbResultSetCache getResultSetCache(String string, String string2, String string3, DmdbStatement dmdbStatement) {
        DmdbResultSetKey dmdbResultSetKey = new DmdbResultSetKey(string, string2, string3, dmdbStatement);
        DmdbResultSetCache dmdbResultSetCache = (DmdbResultSetCache)jh.get(dmdbResultSetKey);
        if (dmdbResultSetCache == null) {
            return null;
        }
        if (dmdbResultSetCache.refreshed(dmdbStatement.K)) {
            jh.remove(dmdbResultSetKey);
            ji.remove(dmdbResultSetKey);
            return null;
        }
        DmdbResultSetCachePool.refreshKeyList(dmdbResultSetKey);
        return dmdbResultSetCache;
    }
}

