/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.b.d;
import dm.jdbc.b.h;
import dm.jdbc.b.n;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbResultSetCachePool;
import dm.jdbc.filter.Filterable;
import dm.jdbc.parser.SQLProcessor;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.StringUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class DmdbStatement
extends Filterable
implements Statement {
    public int id;
    public String fm;
    public boolean fn;
    public h jg;
    public DmdbConnection K;
    public int kB;
    public int kC;
    public int hd;
    public String kD;
    public int kE;
    public long kF;
    public boolean kG;
    public int kH;
    public int iU = 1000;
    public int iV;
    public long kI;
    public boolean kJ = false;
    public boolean closed = true;
    public SQLWarning kK;
    public List kL = null;
    public DmdbResultSet kM;
    public List kN = new ArrayList(3);
    public boolean kO = true;
    public d[] iI = new d[0];
    public int type = 1;
    public static final int STATEMENT = 1;
    public static final int PREPARED_STATEMENT = 2;
    public static final int CALLABLE_STATEMENT = 3;
    public boolean running = false;

    public DmdbStatement(DmdbConnection dmdbConnection, int n2, int n3, int n4) {
        super(dmdbConnection, null);
        if (n2 == 1005) {
            dmdbConnection.addSQLWarning(DBError.getSQLWarning(DBError.ECJDBC_WARNING_UNSUPPORT_RESULTSET_TYPE));
            n2 = 1004;
        }
        this.K = dmdbConnection;
        this.kB = n2;
        this.kC = n3;
        this.hd = n4;
        this.kG = dmdbConnection.connection_property_escapeProcess;
        this.kF = dmdbConnection.connection_property_maxRows;
        this.kH = dmdbConnection.connection_property_sessionTimeout;
        this.allocateHandle();
    }

    private void allocateHandle() {
        n n2;
        n n3 = n2 = this.K.hg != null && this.K.hg.size() > 0 ? (n)this.K.hg.get() : null;
        if (n2 != null) {
            this.id = n2.fl;
            this.fm = n2.fm;
            this.fn = n2.fn;
        } else {
            this.K.hc.a(this);
            long l2 = this.id;
            if (this.id < 0) {
                l2 = 0xFFFFFFFFL & l2;
            }
            this.fm = "DM7CUR" + l2;
        }
        this.closed = false;
    }

    public boolean do_execute(String string) {
        return this.do_execute(string, 2);
    }

    public boolean do_execute(String string, int n2) {
        try {
            this.beforeExecute();
            this.executeInner(string, (short)0, n2 == 1);
            boolean bl = this.kM != null;
            return bl;
        }
        finally {
            this.afterExecute();
        }
    }

    public boolean do_execute(String string, int[] nArray) {
        int n2 = nArray != null && nArray.length > 0 ? 1 : 2;
        return this.do_execute(string, n2);
    }

    public boolean do_execute(String string, String[] stringArray) {
        int n2 = stringArray != null && stringArray.length > 0 ? 1 : 2;
        return this.do_execute(string, n2);
    }

    public DmdbResultSet do_executeQuery(String string) {
        try {
            this.beforeExecute();
            this.executeInner(string, (short)1, false);
            DmdbResultSet dmdbResultSet = this.kM == null ? DmdbResultSet.newEmptyResultSet(this) : this.kM;
            return dmdbResultSet;
        }
        finally {
            this.afterExecute();
        }
    }

    public int do_executeUpdate(String string) {
        return this.do_executeUpdate(string, 2);
    }

    public int do_executeUpdate(String string, int n2) {
        try {
            this.beforeExecute();
            this.executeInner(string, (short)2, n2 == 1);
            int n3 = this.do_getUpdateCount();
            return n3;
        }
        finally {
            this.afterExecute();
        }
    }

    public int do_executeUpdate(String string, int[] nArray) {
        int n2 = nArray != null && nArray.length > 0 ? 1 : 2;
        return this.do_executeUpdate(string, n2);
    }

    public int do_executeUpdate(String string, String[] stringArray) {
        int n2 = stringArray != null && stringArray.length > 0 ? 1 : 2;
        return this.do_executeUpdate(string, n2);
    }

    public int[] do_executeBatch() {
        try {
            this.beforeExecute();
            if (this.K.readOnly) {
                DBError.ECJDBC_READ_ONLY_CONNECTION.throwException(new String[0]);
            }
            if (this.kL != null && this.kL.size() > 0) {
                int n2 = this.kL.size();
                int[] nArray = new int[n2];
                ArrayList<String> arrayList = new ArrayList<String>();
                SQLException sQLException = null;
                int n3 = 0;
                while (n3 < n2) {
                    sQLException = null;
                    try {
                        this.executeInner((String)this.kL.get(n3), (short)2, false);
                        nArray[n3] = ConvertUtil.toInt(!this.K.compatibleOracle() ? this.do_getLargeUpdateCount() : -2L);
                        if (this.jg.ei) {
                            DBError.ECJDBC_INVALID_SQL_TYPE.throwException(new String[0]);
                        }
                    }
                    catch (SQLException sQLException2) {
                        nArray[n3] = !this.K.compatibleOracle() ? -3 : -2;
                        sQLException = sQLException2;
                    }
                    if (sQLException != null) {
                        if (this.K.connection_property_continueBatchOnError) {
                            arrayList.add("sql[" + n3 + "]:" + sQLException.getErrorCode() + ", " + sQLException.getMessage());
                            SQLWarning sQLWarning = new SQLWarning("sql[" + n3 + "]:" + sQLException.getErrorCode() + ", " + sQLException.getMessage());
                            this.addSQLWarning(sQLWarning);
                        } else {
                            int[] nArray2 = new int[n3];
                            System.arraycopy(nArray, 0, nArray2, 0, n3);
                            DBError.throwBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray2);
                        }
                    }
                    ++n3;
                }
                if (arrayList.size() > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string : arrayList) {
                        stringBuilder.append(StringUtil.LINE_SEPARATOR).append(string);
                    }
                    DBError.throwBatchUpdateException(String.valueOf(DBError.EC_BP_WITH_ERROR.reason) + stringBuilder.toString(), DBError.EC_BP_WITH_ERROR.fO, DBError.EC_BP_WITH_ERROR.fN, nArray);
                }
                int[] nArray3 = nArray;
                return nArray3;
            }
            int[] nArray = new int[]{};
            return nArray;
        }
        finally {
            this.do_clearBatch();
            this.afterExecute();
        }
    }

    public void do_addBatch(String string) {
        if (StringUtil.isEmpty(string)) {
            DBError.ECJDBC_SQL_IS_EMPTY.throwException(new String[0]);
        }
        if (this.kL == null) {
            this.kL = new ArrayList(10);
        }
        this.kL.add(string);
    }

    public void do_clearBatch() {
        if (this.kL != null && this.kL.size() > 0) {
            this.kL.clear();
        }
    }

    public void do_setPoolable(boolean bl) {
        this.kO = bl;
    }

    public boolean do_isPoolable() {
        return this.kO;
    }

    public void reconnect() {
        this.free();
        this.allocateHandle();
    }

    public void free() {
        this.clearResultSets();
        try {
            if (this.K != null && this.K.hc != null && !this.K.closed) {
                this.K.hc.f(this.id);
            }
        }
        catch (Exception exception) {}
        this.closed = true;
    }

    public void do_close() {
        this.do_clearBatch();
        this.do_clearWarnings();
        this.clearResultSets();
        try {
            if (!this.closed && this.kO && this.K.connection_property_stmtPoolMaxSize > 0) {
                this.pool();
            } else {
                this.free();
            }
        }
        finally {
            if (this.K != null && this.K.hh != null) {
                this.K.hh.remove(this);
            }
            this.K = null;
            this.closed = true;
        }
    }

    public void pool() {
        this.K.hg.put(new n(this.id, this.fm, this.fn));
    }

    public void clearResultSets() {
        for (DmdbResultSet dmdbResultSet : this.kN) {
            if (dmdbResultSet == null) continue;
            dmdbResultSet.closed = true;
        }
        this.kN.clear();
        if (this.kM != null) {
            this.kM.closed = true;
            this.kM = null;
        }
    }

    public void do_clearWarnings() {
        this.kK = null;
    }

    public void addSQLWarning(SQLWarning sQLWarning) {
        if (this.kK == null) {
            this.kK = sQLWarning;
        } else {
            this.kK.setNextWarning(sQLWarning);
        }
    }

    public void do_cancel() {
        this.checkClosed();
        if (this.running) {
            this.K.do_reset();
        }
    }

    public void do_setCursorName(String string) {
        if (StringUtil.isEmpty(string)) {
            return;
        }
        this.checkClosed();
        this.K.hc.a(this, string);
    }

    public DmdbResultSet do_getResultSet() {
        return this.kM;
    }

    public int do_getUpdateCount() {
        return this.jg.ei ? -1 : ConvertUtil.toInt(this.jg.updateCount);
    }

    public boolean do_getMoreResults() {
        return this.do_getMoreResults(1);
    }

    public void do_setFetchDirection(int n2) {
        if (n2 == 1000 || n2 == 1001) {
            this.iU = n2;
        } else if (n2 == 1002) {
            this.iU = 1000;
        } else {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwException(new String[0]);
        }
    }

    public void do_setFetchSize(int n2) {
        if (n2 < 0 && n2 != Integer.MIN_VALUE || this.kF != 0L && this.kF != -1L && (long)n2 > this.kF) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwException(new String[0]);
        }
        this.iV = n2;
    }

    public boolean do_getMoreResults(int n2) {
        this.checkClosed();
        this.jg.updateCount = -1L;
        if (!this.jg.ei) {
            return false;
        }
        short s2 = (short)(this.kM.iH + 1);
        switch (n2) {
            case 1: {
                this.kM.do_close();
                break;
            }
            case 3: {
                this.clearResultSets();
                break;
            }
            case 2: {
                this.kN.add(this.kM);
                break;
            }
            default: {
                DBError.ECJDBC_UNSUPPORTED_PARAM.throwException(new String[0]);
            }
        }
        this.kM = null;
        h h2 = this.K.hc.a(this, (short)0);
        this.jg.ei = h2.ei;
        if (h2.ei) {
            this.kM = new DmdbResultSet(s2, this, h2);
        }
        return h2.ei;
    }

    public DmdbResultSet do_getGeneratedKeys() {
        d[] dArray = new d[]{new d()};
        dArray[0].type = 8;
        dArray[0].prec = 8;
        dArray[0].scale = 0;
        dArray[0].ao = "BIGINT";
        dArray[0].name = "AUTO_GEN_KEY";
        dArray[0].ap = false;
        Object object = null;
        if (this.jg.ew.size() > 0) {
            object = new byte[this.jg.ew.size()][2][];
            int n2 = 0;
            while (n2 < this.jg.ew.size()) {
                object[n2][1] = new byte[8];
                ByteUtil.setLong(object[n2][1], 0, (Long)this.jg.ew.get(n2));
                ++n2;
            }
        } else {
            object = new byte[][][]{};
        }
        return DmdbResultSet.newLocalResultSet(this, dArray, object);
    }

    protected void beforeExecute() {
        this.checkClosed();
        this.do_clearWarnings();
        this.clearResultSets();
        this.running = true;
    }

    protected void afterExecute() {
        this.running = false;
    }

    private void executeInner(String string, short s2, boolean bl) {
        DmdbResultSetCache dmdbResultSetCache;
        if (StringUtil.isEmpty(string)) {
            DBError.ECJDBC_SQL_IS_EMPTY.throwException(new String[0]);
        }
        if (this.kG) {
            string = this.K.do_nativeSQL(string);
        }
        this.kD = string;
        LinkedList linkedList = null;
        try {
            if (this.K.gw) {
                linkedList = new LinkedList();
                this.kD = SQLProcessor.execOpt(this.kD, linkedList, this.K.getServerEncoding());
            }
        }
        catch (Exception exception) {
            this.kD = string;
            linkedList = null;
        }
        if (this.K.connection_property_enRsCache && (dmdbResultSetCache = DmdbResultSetCachePool.getResultSetCache(this.K.gF, this.K.gz, this.kD, this)) != null) {
            this.kM = dmdbResultSetCache.getResultSet(this);
            this.jg = dmdbResultSetCache.jg;
            return;
        }
        if (linkedList != null && linkedList.size() > 0) {
            try {
                this.jg = this.K.hc.a(this, bl, linkedList);
            }
            catch (SQLException sQLException) {
                if (DBError.ECJDBC_COMMUNITION_ERROR.fN == sQLException.getErrorCode() || DBError.EC_RN_OPERATION_CANCELED.fN == sQLException.getErrorCode() || DBError.EC_EXCEED_SESSION_REQUEST_LIMIT.fN == sQLException.getErrorCode()) {
                    throw sQLException;
                }
                this.kD = string;
                this.jg = this.K.hc.a(this, s2, bl);
            }
        } else {
            this.jg = this.K.hc.a(this, s2, bl);
        }
        if (this.jg.ei) {
            this.kM = this.createAndCacheResultSet((short)1, this.jg);
        }
        if (s2 == 2 && !this.K.compatibleOracle() && this.kM != null) {
            DBError.ECJDBC_INVALID_SQL_TYPE.throwException(new String[0]);
        }
    }

    protected DmdbResultSet createAndCacheResultSet(short s2, h h2) {
        if (this.K.connection_property_enRsCache && h2.el > 0 && (long)h2.ej.length == h2.updateCount) {
            DmdbResultSetCachePool.addResultSet(this, this.kD, h2);
        }
        return new DmdbResultSet(s2, this, h2);
    }

    protected void checkClosed() {
        if (this.K != null) {
            this.K.checkClosed();
        }
        if (this.do_isClosed()) {
            DBError.ECJDBC_STATEMENT_HANDLE_CLOSED.throwException(new String[0]);
        }
    }

    public int do_getMaxFieldSize() {
        return this.kE;
    }

    public void do_setMaxFieldSize(int n2) {
        if (n2 < 0) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwException(new String[0]);
        }
        this.kE = n2;
    }

    public int do_getMaxRows() {
        return ConvertUtil.toInt(this.kF);
    }

    public void do_setMaxRows(int n2) {
        if (n2 < 0) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwException(new String[0]);
        }
        this.kF = n2;
    }

    public void do_setEscapeProcessing(boolean bl) {
        this.kG = bl;
    }

    public int do_getQueryTimeout() {
        return this.kH;
    }

    public void do_setQueryTimeout(int n2) {
        if (n2 < 0) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwException(new String[0]);
        }
        this.kH = n2;
    }

    public SQLWarning do_getWarnings() {
        return this.kK;
    }

    public int do_getFetchDirection() {
        return this.iU;
    }

    public int do_getFetchSize() {
        return this.iV;
    }

    public int do_getResultSetConcurrency() {
        return this.kC;
    }

    public int do_getResultSetType() {
        return this.kB;
    }

    public DmdbConnection do_getConnection() {
        return this.K;
    }

    public int do_getResultSetHoldability() {
        return this.hd;
    }

    public boolean do_isClosed() {
        return this.closed;
    }

    public void do_closeOnCompletion() {
        this.kJ = true;
    }

    public boolean do_isCloseOnCompletion() {
        return this.kJ;
    }

    public long do_getLargeUpdateCount() {
        return this.jg.ei ? -1L : this.jg.updateCount;
    }

    public void do_setLargeMaxRows(long l2) {
        if (l2 < 0L) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwException(new String[0]);
        }
        this.kF = l2;
    }

    public long do_getLargeMaxRows() {
        return this.kF;
    }

    public long[] do_executeLargeBatch() {
        try {
            this.beforeExecute();
            if (this.K.readOnly) {
                DBError.ECJDBC_READ_ONLY_CONNECTION.throwException(new String[0]);
            }
            if (this.kL != null && this.kL.size() > 0) {
                int n2 = this.kL.size();
                long[] lArray = new long[n2];
                ArrayList<String> arrayList = new ArrayList<String>();
                SQLException sQLException = null;
                int n3 = 0;
                while (n3 < n2) {
                    sQLException = null;
                    try {
                        this.executeInner((String)this.kL.get(n3), (short)2, false);
                        long l2 = lArray[n3] = !this.K.compatibleOracle() ? this.do_getLargeUpdateCount() : -2L;
                        if (this.jg.ei) {
                            DBError.ECJDBC_INVALID_SQL_TYPE.throwException(new String[0]);
                        }
                    }
                    catch (SQLException sQLException2) {
                        lArray[n3] = !this.K.compatibleOracle() ? -3 : -2;
                        sQLException = sQLException2;
                    }
                    if (sQLException != null) {
                        if (this.K.connection_property_continueBatchOnError) {
                            arrayList.add("sql[" + n3 + "]:" + sQLException.getErrorCode() + ", " + sQLException.getMessage());
                            SQLWarning sQLWarning = new SQLWarning("sql[" + n3 + "]:" + sQLException.getErrorCode() + ", " + sQLException.getMessage());
                            this.addSQLWarning(sQLWarning);
                        } else {
                            long[] lArray2 = new long[n3];
                            System.arraycopy(lArray, 0, lArray2, 0, n3);
                            DBError.throwBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), lArray2);
                        }
                    }
                    ++n3;
                }
                if (arrayList.size() > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string : arrayList) {
                        stringBuilder.append(StringUtil.LINE_SEPARATOR).append(string);
                    }
                    DBError.throwBatchUpdateException(String.valueOf(DBError.EC_BP_WITH_ERROR.reason) + stringBuilder.toString(), DBError.EC_BP_WITH_ERROR.fO, DBError.EC_BP_WITH_ERROR.fN, lArray);
                }
                long[] lArray3 = lArray;
                return lArray3;
            }
            long[] lArray = new long[]{};
            return lArray;
        }
        finally {
            this.do_clearBatch();
            this.afterExecute();
        }
    }

    public long do_executeLargeUpdate(String string) {
        return this.do_executeLargeUpdate(string, 2);
    }

    public long do_executeLargeUpdate(String string, int n2) {
        try {
            this.beforeExecute();
            this.executeInner(string, (short)2, n2 == 1);
            long l2 = this.do_getLargeUpdateCount();
            return l2;
        }
        finally {
            this.afterExecute();
        }
    }

    public long do_executeLargeUpdate(String string, int[] nArray) {
        int n2 = nArray != null && nArray.length > 0 ? 1 : 2;
        return this.do_executeLargeUpdate(string, n2);
    }

    public long do_executeLargeUpdate(String string, String[] stringArray) {
        int n2 = stringArray != null && stringArray.length > 0 ? 1 : 2;
        return this.do_executeLargeUpdate(string, n2);
    }

    protected void checkConnection() {
        if (this.K == null) {
            DBError.ECJDBC_CONNECTION_CLOSED.throwException(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeQuery(string);
            }
            return this.filterChain.reset().Statement_executeQuery(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeUpdate(string);
            }
            return this.filterChain.reset().Statement_executeUpdate(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.K == null) {
            return;
        }
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_close();
            } else {
                this.filterChain.reset().Statement_close(this);
            }
        }
    }

    @Override
    public int getMaxFieldSize() {
        if (this.filterChain == null) {
            return this.do_getMaxFieldSize();
        }
        return this.filterChain.reset().Statement_getMaxFieldSize(this);
    }

    @Override
    public void setMaxFieldSize(int n2) {
        if (this.filterChain == null) {
            this.do_setMaxFieldSize(n2);
        } else {
            this.filterChain.reset().Statement_setMaxFieldSize(this, n2);
        }
    }

    @Override
    public int getMaxRows() {
        if (this.filterChain == null) {
            return this.do_getMaxRows();
        }
        return this.filterChain.reset().Statement_getMaxRows(this);
    }

    @Override
    public void setMaxRows(int n2) {
        if (this.filterChain == null) {
            this.do_setMaxRows(n2);
        } else {
            this.filterChain.reset().Statement_setMaxRows(this, n2);
        }
    }

    @Override
    public void setEscapeProcessing(boolean bl) {
        if (this.filterChain == null) {
            this.do_setEscapeProcessing(bl);
        } else {
            this.filterChain.reset().Statement_setEscapeProcessing(this, bl);
        }
    }

    @Override
    public int getQueryTimeout() {
        if (this.filterChain == null) {
            return this.do_getQueryTimeout();
        }
        return this.filterChain.reset().Statement_getQueryTimeout(this);
    }

    @Override
    public void setQueryTimeout(int n2) {
        if (this.filterChain == null) {
            this.do_setQueryTimeout(n2);
        } else {
            this.filterChain.reset().Statement_setQueryTimeout(this, n2);
        }
    }

    @Override
    public void cancel() {
        if (this.filterChain == null) {
            this.do_cancel();
        } else {
            this.filterChain.reset().Statement_cancel(this);
        }
    }

    @Override
    public SQLWarning getWarnings() {
        if (this.filterChain == null) {
            return this.do_getWarnings();
        }
        return this.filterChain.reset().Statement_getWarnings(this);
    }

    @Override
    public void clearWarnings() {
        if (this.filterChain == null) {
            this.do_clearWarnings();
        } else {
            this.filterChain.reset().Statement_clearWarnings(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursorName(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setCursorName(string);
            } else {
                this.filterChain.reset().Statement_setCursorName(this, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_execute(string);
            }
            return this.filterChain.reset().Statement_execute(this, string);
        }
    }

    @Override
    public ResultSet getResultSet() {
        if (this.filterChain == null) {
            return this.do_getResultSet();
        }
        return this.filterChain.reset().Statement_getResultSet(this);
    }

    @Override
    public int getUpdateCount() {
        if (this.filterChain == null) {
            return this.do_getUpdateCount();
        }
        return this.filterChain.reset().Statement_getUpdateCount(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getMoreResults();
            }
            return this.filterChain.reset().Statement_getMoreResults(this);
        }
    }

    @Override
    public void setFetchDirection(int n2) {
        if (this.filterChain == null) {
            this.do_setFetchDirection(n2);
        } else {
            this.filterChain.reset().Statement_setFetchDirection(this, n2);
        }
    }

    @Override
    public int getFetchDirection() {
        if (this.filterChain == null) {
            return this.do_getFetchDirection();
        }
        return this.filterChain.reset().Statement_getFetchDirection(this);
    }

    @Override
    public void setFetchSize(int n2) {
        if (this.filterChain == null) {
            this.do_setFetchSize(n2);
        } else {
            this.filterChain.reset().Statement_setFetchSize(this, n2);
        }
    }

    @Override
    public int getFetchSize() {
        if (this.filterChain == null) {
            return this.do_getFetchSize();
        }
        return this.filterChain.reset().Statement_getFetchSize(this);
    }

    @Override
    public int getResultSetConcurrency() {
        if (this.filterChain == null) {
            return this.do_getResultSetConcurrency();
        }
        return this.filterChain.reset().Statement_getResultSetConcurrency(this);
    }

    @Override
    public int getResultSetType() {
        if (this.filterChain == null) {
            return this.do_getResultSetType();
        }
        return this.filterChain.reset().Statement_getResultSetType(this);
    }

    @Override
    public void addBatch(String string) {
        if (this.filterChain == null) {
            this.do_addBatch(string);
        } else {
            this.filterChain.reset().Statement_addBatch(this, string);
        }
    }

    @Override
    public void clearBatch() {
        if (this.filterChain == null) {
            this.do_clearBatch();
        } else {
            this.filterChain.reset().Statement_clearBatch(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeBatch();
            }
            return this.filterChain.reset().Statement_executeBatch(this);
        }
    }

    @Override
    public Connection getConnection() {
        if (this.filterChain == null) {
            return this.do_getConnection();
        }
        return this.filterChain.reset().Statement_getConnection(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getMoreResults(n2);
            }
            return this.filterChain.reset().Statement_getMoreResults(this, n2);
        }
    }

    @Override
    public ResultSet getGeneratedKeys() {
        if (this.filterChain == null) {
            return this.do_getGeneratedKeys();
        }
        return this.filterChain.reset().Statement_getGeneratedKeys(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeUpdate(string, n2);
            }
            return this.filterChain.reset().Statement_executeUpdate(this, string, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, int[] nArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeUpdate(string, nArray);
            }
            return this.filterChain.reset().Statement_executeUpdate(this, string, nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, String[] stringArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeUpdate(string, stringArray);
            }
            return this.filterChain.reset().Statement_executeUpdate(this, string, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_execute(string, n2);
            }
            return this.filterChain.reset().Statement_execute(this, string, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, int[] nArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_execute(string, nArray);
            }
            return this.filterChain.reset().Statement_execute(this, string, nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, String[] stringArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_execute(string, stringArray);
            }
            return this.filterChain.reset().Statement_execute(this, string, stringArray);
        }
    }

    @Override
    public int getResultSetHoldability() {
        if (this.filterChain == null) {
            return this.do_getResultSetHoldability();
        }
        return this.filterChain.reset().Statement_getResultSetHoldability(this);
    }

    @Override
    public boolean isClosed() {
        if (this.filterChain == null) {
            return this.do_isClosed();
        }
        return this.filterChain.reset().Statement_isClosed(this);
    }

    @Override
    public void setPoolable(boolean bl) {
        if (this.filterChain == null) {
            this.do_setPoolable(bl);
        } else {
            this.filterChain.reset().Statement_setPoolable(this, bl);
        }
    }

    @Override
    public boolean isPoolable() {
        if (this.filterChain == null) {
            return this.do_isPoolable();
        }
        return this.filterChain.reset().Statement_isPoolable(this);
    }

    @Override
    public void closeOnCompletion() {
        if (this.filterChain == null) {
            this.do_closeOnCompletion();
        } else {
            this.filterChain.reset().Statement_closeOnCompletion(this);
        }
    }

    @Override
    public boolean isCloseOnCompletion() {
        if (this.filterChain == null) {
            return this.do_isCloseOnCompletion();
        }
        return this.filterChain.reset().Statement_isCloseOnCompletion(this);
    }

    @Override
    public long getLargeUpdateCount() {
        if (this.filterChain == null) {
            return this.do_getLargeUpdateCount();
        }
        return this.filterChain.reset().Statement_getLargeUpdateCount(this);
    }

    @Override
    public void setLargeMaxRows(long l2) {
        if (this.filterChain == null) {
            this.do_setLargeMaxRows(l2);
        } else {
            this.filterChain.reset().Statement_setLargeMaxRows(this, l2);
        }
    }

    @Override
    public long getLargeMaxRows() {
        if (this.filterChain == null) {
            return this.do_getLargeMaxRows();
        }
        return this.filterChain.reset().Statement_getLargeMaxRows(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeBatch();
            }
            return this.filterChain.reset().Statement_executeLargeBatch(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeUpdate(string);
            }
            return this.filterChain.reset().Statement_executeLargeUpdate(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string, int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeUpdate(string, n2);
            }
            return this.filterChain.reset().Statement_executeLargeUpdate(this, string, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string, int[] nArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeUpdate(string, nArray);
            }
            return this.filterChain.reset().Statement_executeLargeUpdate(this, string, nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string, String[] stringArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeUpdate(string, stringArray);
            }
            return this.filterChain.reset().Statement_executeLargeUpdate(this, string, stringArray);
        }
    }

    public Object unwrap(Class clazz) {
        return clazz.cast(this);
    }

    public boolean isWrapperFor(Class clazz) {
        return clazz.isInstance(this);
    }

    public long getRowId() {
        if (this.filterChain == null) {
            return this.do_getRowId();
        }
        return this.filterChain.reset().Statement_getRowId(this);
    }

    public long do_getRowId() {
        return this.jg != null ? this.jg.ev : -1L;
    }

    public ResultSet[] getResultSets() {
        if (this.filterChain == null) {
            return this.do_getResultSets();
        }
        return this.filterChain.reset().Statement_getResultSets(this);
    }

    public ResultSet[] do_getResultSets() {
        return this.kN != null ? this.kN.toArray(new ResultSet[0]) : new ResultSet[]{};
    }

    public String getPrintMsg() {
        if (this.filterChain == null) {
            return this.do_getPrintMsg();
        }
        return this.filterChain.reset().Statement_getPrintMsg(this);
    }

    public String do_getPrintMsg() {
        return this.jg != null ? this.jg.es : "";
    }

    public long getExecuteId() {
        if (this.filterChain == null) {
            return this.do_getExecuteId();
        }
        return this.filterChain.reset().Statement_getExecuteId(this);
    }

    public long do_getExecuteId() {
        return this.jg != null ? this.jg.ey : -1L;
    }

    public int getSqlType() {
        if (this.filterChain == null) {
            return this.do_getSqlType();
        }
        return this.filterChain.reset().Statement_getSqlType(this);
    }

    public int do_getSqlType() {
        int n2;
        short s2 = this.jg.ex;
        switch (s2) {
            case 162: 
            case 178: {
                n2 = 3;
                break;
            }
            case 160: {
                n2 = 1;
                break;
            }
            case 152: {
                n2 = 4;
                break;
            }
            default: {
                n2 = 2;
            }
        }
        return n2;
    }

    public int getRetType() {
        return this.jg != null ? (int)this.jg.ex : 0;
    }
}

