/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.b.d;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.DateUtil;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class DmdbTimestamp
implements Serializable {
    private static final long serialVersionUID = 544720274538766252L;
    public static final long MiSeconds_1900_1970 = 2209017600000L;
    public static final int OFFSET_YEAR = 0;
    public static final int OFFSET_MONTH = 1;
    public static final int OFFSET_DAY = 2;
    public static final int OFFSET_HOUR = 3;
    public static final int OFFSET_MINUTE = 4;
    public static final int OFFSET_SECOND = 5;
    public static final int OFFSET_MILLISECOND = 6;
    public static final int OFFSET_TIMEZONE = 7;
    public static final int DT_LEN = 8;
    public static final int INVALID_VALUE = Integer.MIN_VALUE;
    public int[] kR;
    public int kS = 16;
    public int scale = 6;
    private String kT;
    private int gS;

    public DmdbTimestamp(int[] nArray, int n2, int n3) {
        this.kR = nArray;
        this.kS = n2;
        this.scale = n3;
    }

    public DmdbTimestamp(byte[] byArray, d d2, DmdbConnection dmdbConnection) {
        int[] nArray = DateUtil.decode(byArray, d2.ax, d2.type, d2.scale, dmdbConnection.connection_property_localTimezone, dmdbConnection.go);
        int n2 = DmdbType.isLocalTimeZone(d2.type, d2.scale) ? DmdbType.getLocalTimeZoneScale(d2.type, d2.scale) : d2.scale;
        this.kR = nArray;
        this.kS = d2.type;
        this.scale = n2;
        this.gS = dmdbConnection.gS;
        switch (d2.type) {
            case 14: {
                this.kT = dmdbConnection.gT;
                break;
            }
            case 15: {
                this.kT = dmdbConnection.gW;
                break;
            }
            case 22: {
                this.kT = dmdbConnection.gX;
                break;
            }
            case 16: {
                this.kT = dmdbConnection.gU;
                break;
            }
            case 23: {
                this.kT = dmdbConnection.gV;
                break;
            }
        }
    }

    public static DmdbTimestamp valueOf(String string) {
        int n2;
        int[] nArray;
        return new DmdbTimestamp(nArray, n2, (n2 = DateUtil.toDT(string, nArray = new int[8])) == 14 ? 0 : 6);
    }

    public static DmdbTimestamp valueOf(Date date) {
        int n2 = 0;
        if (date instanceof Timestamp) {
            n2 = ((Timestamp)date).getNanos();
        }
        int[] nArray = DateUtil.toDT(date.getTime(), n2, Calendar.getInstance());
        return new DmdbTimestamp(nArray, 16, 6);
    }

    public java.sql.Date toDate() {
        return DateUtil.toDate(this.kR, null);
    }

    public Time toTime() {
        return DateUtil.toTime(this.kR, null);
    }

    public Timestamp toTimestamp() {
        return DateUtil.toTimestamp(this.kR, null);
    }

    public byte[] toBytes() {
        return DateUtil.encode(this.kR, this.kS, this.scale, this.getTimezone());
    }

    public int[] getDt() {
        return this.kR;
    }

    public long getTime() {
        long l2 = DateUtil.toTimeInMillis(this.kR, null);
        return l2 + (long)this.kR[6];
    }

    public void setTime(long l2) {
        long l3 = l2 / 1000L * 1000L;
        int n2 = (int)(l2 % 1000L * 1000000L);
        if (n2 < 0) {
            n2 += 1000000000;
            l3 = (l2 / 1000L - 1L) * 1000L;
        }
        this.kR = DateUtil.toDT(l3, n2, null);
    }

    public int getTimezone() {
        return this.kR[7];
    }

    public void setTimezone(int n2) {
        if (n2 <= -780 || n2 > 840) {
            DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwException(new String[0]);
        }
        this.kR[7] = n2;
    }

    public long getNano() {
        return this.kR[6] * 1000;
    }

    public void setNano(long l2) {
        this.kR[6] = (int)(l2 / 1000L);
    }

    public String toString() {
        if (StringUtil.isNotEmpty(this.kT)) {
            return DateUtil.toString(this.kR, this.kT, this.gS);
        }
        return DateUtil.toString(this.kR, this.kS, this.scale);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DmdbTimestamp)) {
            return false;
        }
        DmdbTimestamp dmdbTimestamp = (DmdbTimestamp)object;
        return dmdbTimestamp.kS == this.kS && dmdbTimestamp.scale == this.scale && Arrays.equals(this.kR, dmdbTimestamp.kR);
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.kS;
        n2 = 31 * n2 + this.scale;
        n2 = 31 * n2 + Arrays.hashCode(this.kR);
        return n2;
    }

    public static void main(String[] stringArray) {
        DmdbTimestamp dmdbTimestamp = DmdbTimestamp.valueOf("2018-09-07 16:09:13.123456");
        System.out.println(dmdbTimestamp.getTime());
        System.out.println(dmdbTimestamp.getDt());
        System.out.println(dmdbTimestamp.getTimezone());
        dmdbTimestamp.setTime(dmdbTimestamp.getTime());
        System.out.println(dmdbTimestamp);
    }
}

