/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.stat;

import dm.jdbc.b.g;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.filter.stat.ConnectionStat;
import dm.jdbc.filter.stat.ConnectionStatValue;
import dm.jdbc.filter.stat.JdbcStat;
import dm.jdbc.filter.stat.SqlStat;
import dm.jdbc.filter.stat.json.JSONArray;
import dm.jdbc.filter.stat.json.JSONObject;
import dm.jdbc.filter.stat.util.MapComparator;
import dm.jdbc.util.StringUtil;
import java.lang.management.ManagementFactory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.JMException;

public class StatService {
    public static final String PROP_NAME_SORT = "sort";
    public static final String PROP_NAME_SORT_FIELD = "field";
    public static final String PROP_NAME_SORT_TYPE = "direction";
    public static final String PROP_NAME_SEARCH = "search";
    public static final String PROP_NAME_PAGE_NUM = "pageNum";
    public static final String PROP_NAME_PAGE_SIZE = "pageSize";
    public static final String PROP_NAME_PAGE_COUNT = "pageCount";
    public static final String PROP_NAME_TOTAL_ROW_COUNT = "totalRowCount";
    public static final String PROP_NAME_FLUSH_FREQ = "flushFreq";
    public static final String PROP_NAME_DATASOURCE_ID = "dataSourceId";
    public static final String PROP_NAME_SQL_ID = "sqlId";
    public static final String URL_SQL = "/sql.json";
    public static final String URL_SQL_DETAIL = "/sqlDetail.json";
    public static final String URL_DATASOURCE = "/dataSource.json";
    public static final String URL_DATASOURCE_DETAIL = "/dataSourceDetail.json";
    public static final String URL_DRIVER_INFO = "/driverInfo.json";
    public static final int RESULT_CODE_SUCCESS = 1;
    public static final int RESULT_CODE_ERROR = -1;
    private static final int DEFAULT_PAGE_NUM = 1;
    private static final int DEFAULT_PAGE_SIZE = Integer.MAX_VALUE;
    private static final String DEFAULT_ORDER_TYPE = "asc";
    private static final String DEFAULT_ORDERBY = "DataSourceId";
    public static JdbcStat jdbcStat = new JdbcStat(-1);
    private static final StatService instance = new StatService();

    private StatService() {
    }

    public static StatService getInstance() {
        return instance;
    }

    public List service(String string) {
        return this.service(string, null);
    }

    public List service(String string, Properties properties) {
        if (properties != null) {
            properties.putAll((Map<?, ?>)this.parseUrl(string));
        } else {
            properties = this.parseUrl(string);
        }
        if (string.startsWith(URL_SQL)) {
            List list = this.getSqlStatList(properties);
            list = this.comparatorOrderBy(list, properties);
            properties.put(PROP_NAME_FLUSH_FREQ, (Object)g.dY);
            return list;
        }
        if (string.startsWith(URL_SQL_DETAIL)) {
            List list = this.getSqlStatDetailList(properties);
            return list;
        }
        if (string.startsWith(URL_DATASOURCE)) {
            List list = this.getConnStatList(properties);
            list = this.comparatorOrderBy(list, properties);
            properties.put(PROP_NAME_FLUSH_FREQ, (Object)g.dY);
            return list;
        }
        if (string.startsWith(URL_DATASOURCE_DETAIL)) {
            List list = this.getConnStatDetailList(properties);
            return list;
        }
        if (string.startsWith(URL_DRIVER_INFO)) {
            List list = this.getDriverInfoList(properties);
            return list;
        }
        return null;
    }

    private void resetPageInfo(Properties properties, int n2, int n3, int n4) {
        try {
            if (properties != null && properties.containsKey(PROP_NAME_PAGE_SIZE)) {
                properties.put(PROP_NAME_PAGE_COUNT, (Object)n3);
                properties.put(PROP_NAME_TOTAL_ROW_COUNT, (Object)n2);
                properties.put(PROP_NAME_PAGE_NUM, (Object)n4);
            }
        }
        catch (Exception exception) {}
    }

    private List getDriverInfoList(Properties properties) {
        CharSequence charSequence;
        ArrayList arrayList = new ArrayList();
        HashMap<String, CharSequence> hashMap = new HashMap<String, CharSequence>();
        hashMap.put("name", "\u9a71\u52a8");
        hashMap.put("value", "dm.jdbc.driver.DmDriver");
        arrayList.add(hashMap);
        hashMap = new HashMap();
        hashMap.put("name", "\u7248\u672c");
        hashMap.put("value", "8.1.0.147(2019.03.27)");
        arrayList.add(hashMap);
        hashMap = new HashMap();
        hashMap.put("name", "\u542f\u52a8\u65f6\u95f4");
        hashMap.put("value", new Timestamp(DmDriver.STARTUP_TIME).toString());
        arrayList.add(hashMap);
        hashMap = new HashMap();
        hashMap.put("name", "java\u7248\u672c");
        hashMap.put("value", System.getProperty("java.version"));
        arrayList.add(hashMap);
        hashMap = new HashMap();
        hashMap.put("name", "Java Home");
        hashMap.put("value", System.getProperty("java.home"));
        arrayList.add(hashMap);
        hashMap = new HashMap();
        hashMap.put("name", "jvm\u540d\u79f0");
        hashMap.put("value", System.getProperty("java.vm.name"));
        arrayList.add(hashMap);
        hashMap = new HashMap();
        hashMap.put("name", "jvm\u53c2\u6570");
        List<String> list = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (list != null && list.size() > 0) {
            charSequence = new StringBuilder();
            for (String string : list) {
                charSequence.append(string).append("<br>");
            }
            hashMap.put("value", charSequence.toString());
        } else {
            hashMap.put("value", "");
        }
        arrayList.add(hashMap);
        hashMap = new HashMap();
        hashMap.put("name", "java.library.path");
        charSequence = System.getProperty("java.library.path");
        if (StringUtil.isNotEmpty((String)charSequence)) {
            hashMap.put("value", charSequence);
        } else {
            hashMap.put("value", "");
        }
        arrayList.add(hashMap);
        hashMap = new HashMap();
        hashMap.put("name", "java.class.path");
        charSequence = System.getProperty("java.class.path");
        if (StringUtil.isNotEmpty((String)charSequence)) {
            hashMap.put("value", charSequence);
        } else {
            hashMap.put("value", "");
        }
        arrayList.add(hashMap);
        return arrayList;
    }

    private List getSqlStatList(Properties properties) {
        ArrayList<Map> arrayList = new ArrayList<Map>();
        Map map = jdbcStat.getConnStatMap();
        for (ConnectionStat connectionStat : map.values()) {
            Map map2 = connectionStat.getSqlStatMap();
            for (SqlStat sqlStat : map2.values()) {
                try {
                    Map map3 = sqlStat.getData();
                    long l2 = (Long)map3.get("ExecuteCount");
                    long l3 = (Long)map3.get("RunningCount");
                    if (l2 == 0L && l3 == 0L || !this.filterStatData(map3, properties)) continue;
                    arrayList.add(map3);
                }
                catch (Exception exception) {}
            }
        }
        return arrayList;
    }

    private boolean filterStatData(Map map, Properties properties) {
        JSONArray jSONArray = null;
        if (properties.containsKey(PROP_NAME_SEARCH)) {
            jSONArray = (JSONArray)properties.get(PROP_NAME_SEARCH);
        }
        if (jSONArray != null && jSONArray.length() > 0) {
            int n2 = 0;
            while (n2 < jSONArray.length()) {
                block20: {
                    String string;
                    String string2;
                    String string3;
                    block27: {
                        block26: {
                            block25: {
                                String string4;
                                String string5;
                                JSONObject jSONObject;
                                block21: {
                                    int n3;
                                    int n4;
                                    block24: {
                                        block23: {
                                            block22: {
                                                try {
                                                    jSONObject = jSONArray.getJSONObject(n2);
                                                    string5 = jSONObject.get(PROP_NAME_SORT_FIELD).toString().trim();
                                                    string3 = jSONObject.get("operator").toString().trim();
                                                    string4 = jSONObject.get("type").toString().trim();
                                                    if (!map.containsKey(string5)) break block20;
                                                    if (!StringUtil.equalsIgnoreCase(string4, "int")) break block21;
                                                    n4 = Integer.parseInt(StringUtil.trimToEmpty(map.get(string5).toString()));
                                                    if (!StringUtil.equalsIgnoreCase(string3, "is")) break block22;
                                                    int n5 = jSONObject.getInt("value");
                                                    if (n5 != n4) {
                                                        return false;
                                                    }
                                                    break block20;
                                                }
                                                catch (Exception exception) {}
                                            }
                                            if (!StringUtil.equalsIgnoreCase(string3, "between")) break block23;
                                            int n6 = ((JSONArray)jSONObject.get("value")).getInt(0);
                                            int n7 = ((JSONArray)jSONObject.get("value")).getInt(1);
                                            if (n4 < n6 || n4 > n7) {
                                                return false;
                                            }
                                            break block20;
                                        }
                                        if (!StringUtil.equalsIgnoreCase(string3, "less")) break block24;
                                        int n8 = jSONObject.getInt("value");
                                        if (n4 >= n8) {
                                            return false;
                                        }
                                        break block20;
                                    }
                                    if (StringUtil.equalsIgnoreCase(string3, "more") && n4 <= (n3 = jSONObject.getInt("value"))) {
                                        return false;
                                    }
                                    break block20;
                                }
                                if (!StringUtil.equalsIgnoreCase(string4, "text")) break block20;
                                string2 = jSONObject.getString("value");
                                string = StringUtil.trimToEmpty(map.get(string5).toString());
                                if (!StringUtil.equalsIgnoreCase(string3, "is")) break block25;
                                if (!StringUtil.equalsIgnoreCase(string, string2)) {
                                    return false;
                                }
                                break block20;
                            }
                            if (!StringUtil.equalsIgnoreCase(string3, "begins")) break block26;
                            if (!string.toUpperCase().startsWith(string2.toUpperCase())) {
                                return false;
                            }
                            break block20;
                        }
                        if (!StringUtil.equalsIgnoreCase(string3, "contains")) break block27;
                        if (!string.toUpperCase().contains(string2.toUpperCase())) {
                            return false;
                        }
                        break block20;
                    }
                    if (StringUtil.equalsIgnoreCase(string3, "ends") && !string.toUpperCase().endsWith(string2.toUpperCase())) {
                        return false;
                    }
                }
                ++n2;
            }
        }
        return true;
    }

    private Properties parseUrl(String string) {
        String[] stringArray;
        Properties properties = new Properties();
        if (string == null || (string = string.trim()).length() == 0) {
            return properties;
        }
        String string2 = StringUtil.subString(string, "?", null);
        if (string2 == null || string2.length() == 0) {
            return properties;
        }
        String[] stringArray2 = stringArray = string2.split("&");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string3 = stringArray2[n3];
            int n4 = string3.indexOf("=");
            if (n4 > 0) {
                String string4 = string3.substring(0, n4);
                String string5 = string3.substring(n4 + 1);
                properties.put(string4, string5);
            }
            ++n3;
        }
        return properties;
    }

    private List comparatorOrderBy(List list, Properties properties) {
        int n2;
        int n3;
        if (list == null) {
            list = new ArrayList();
        }
        String string = DEFAULT_ORDERBY;
        String string2 = DEFAULT_ORDER_TYPE;
        Integer n4 = 1;
        Integer n5 = Integer.MAX_VALUE;
        if (properties != null) {
            String string3;
            if (properties.containsKey(PROP_NAME_SORT_FIELD)) {
                string = StringUtil.trimToEmpty(properties.get(PROP_NAME_SORT_FIELD).toString());
            }
            if (properties.containsKey(PROP_NAME_SORT_TYPE)) {
                string2 = StringUtil.trimToEmpty(properties.get(PROP_NAME_SORT_TYPE).toString());
            }
            if (properties.containsKey(PROP_NAME_PAGE_NUM) && (string3 = StringUtil.trimToEmpty(properties.get(PROP_NAME_PAGE_NUM).toString())) != null && string3.length() != 0) {
                n4 = Integer.parseInt(string3);
            }
            if (properties.containsKey(PROP_NAME_PAGE_SIZE) && (string3 = StringUtil.trimToEmpty(properties.get(PROP_NAME_PAGE_SIZE).toString())) != null && string3.length() > 0) {
                n5 = Integer.parseInt(string3);
            }
        }
        int n6 = n3 = (n3 = (int)Math.ceil((double)(n2 = list.size()) * 1.0 / (double)n5.intValue())) < 1 ? 1 : n3;
        if (n4 > n3) {
            n4 = n3;
        }
        if (list.size() > 0) {
            if (StringUtil.isNotEmpty(string)) {
                Collections.sort(list, new MapComparator(string, !DEFAULT_ORDER_TYPE.equals(string2)));
            }
            int n7 = (n4 - 1) * n5;
            int n8 = n4 * n5;
            if (n8 > n2) {
                n8 = n2;
            }
            list = list.subList(n7, n8);
        }
        this.resetPageInfo(properties, n2, n3, n4);
        return list;
    }

    private List getConnStatList(Properties properties) {
        ArrayList<Map> arrayList = new ArrayList<Map>();
        Map map = jdbcStat.getConnStatMap();
        String string = null;
        if (properties.containsKey(PROP_NAME_DATASOURCE_ID)) {
            string = properties.get(PROP_NAME_DATASOURCE_ID).toString();
        }
        for (ConnectionStat connectionStat : map.values()) {
            try {
                Map map2 = connectionStat.getData();
                long l2 = (Long)map2.get("ConnCount");
                if (l2 == 0L) continue;
                if (StringUtil.isNotEmpty(string)) {
                    if (!string.equalsIgnoreCase(connectionStat.getId())) continue;
                    arrayList.add(map2);
                    break;
                }
                if (!this.filterStatData(map2, properties)) continue;
                arrayList.add(map2);
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    private List getConnStatDetailList(Properties properties) {
        ArrayList<HashMap<String, String>> arrayList = new ArrayList<HashMap<String, String>>();
        Object object = null;
        Map map = jdbcStat.getConnStatMap();
        String string = null;
        if (properties.containsKey(PROP_NAME_DATASOURCE_ID)) {
            string = properties.get(PROP_NAME_DATASOURCE_ID).toString();
        }
        if (StringUtil.isNotEmpty(string)) {
            for (Object object2 : map.values()) {
                try {
                    if (!string.equals(((ConnectionStat)object2).getId())) continue;
                    object = object2;
                    break;
                }
                catch (Exception exception) {}
            }
            if (object != null) {
                Object object2;
                object2 = ((ConnectionStat)object).getValue(false);
                HashMap<String, String> hashMap = new HashMap(2);
                hashMap.put("name", "\u6570\u636e\u6e90");
                hashMap.put("value", ((ConnectionStatValue)object2).getUrl());
                arrayList.add(hashMap);
                hashMap = new HashMap<String, String>(2);
                hashMap.put("name", "\u603b\u4f1a\u8bdd\u6570");
                hashMap.put("value", (String)((Object)Long.valueOf(((ConnectionStatValue)object2).getConnCount())));
                arrayList.add(hashMap);
                hashMap = new HashMap(2);
                hashMap.put("name", "\u6d3b\u52a8\u4f1a\u8bdd\u6570");
                hashMap.put("value", (String)((Object)Long.valueOf(((ConnectionStatValue)object2).getActiveConnCount())));
                arrayList.add(hashMap);
                hashMap = new HashMap(2);
                hashMap.put("name", "\u6d3b\u52a8\u4f1a\u8bdd\u6570\u5cf0\u503c");
                hashMap.put("value", (String)((Object)Long.valueOf(((ConnectionStatValue)object2).getMaxActiveConnCount())));
                arrayList.add(hashMap);
                hashMap = new HashMap(2);
                hashMap.put("name", "\u603b\u53e5\u67c4\u6570");
                hashMap.put("value", (String)((Object)Long.valueOf(((ConnectionStatValue)object2).getStmtCount())));
                arrayList.add(hashMap);
                hashMap = new HashMap(2);
                hashMap.put("name", "\u6d3b\u52a8\u53e5\u67c4\u6570");
                hashMap.put("value", (String)((Object)Long.valueOf(((ConnectionStatValue)object2).getActiveStmtCount())));
                arrayList.add(hashMap);
                hashMap = new HashMap(2);
                hashMap.put("name", "\u6d3b\u52a8\u53e5\u67c4\u6570\u5cf0\u503c");
                hashMap.put("value", (String)((Object)Long.valueOf(((ConnectionStatValue)object2).getMaxActiveStmtCount())));
                arrayList.add(hashMap);
                hashMap = new HashMap(2);
                hashMap.put("name", "\u6267\u884c\u6b21\u6570");
                hashMap.put("value", (String)((Object)Long.valueOf(((ConnectionStatValue)object2).getExecuteCount())));
                arrayList.add(hashMap);
                hashMap = new HashMap(2);
                hashMap.put("name", "\u6267\u884c\u51fa\u9519\u6b21\u6570");
                hashMap.put("value", (String)((Object)Long.valueOf(((ConnectionStatValue)object2).getErrorCount())));
                arrayList.add(hashMap);
                hashMap = new HashMap(2);
                hashMap.put("name", "\u63d0\u4ea4\u6b21\u6570");
                hashMap.put("value", (String)((Object)Long.valueOf(((ConnectionStatValue)object2).getCommitCount())));
                arrayList.add(hashMap);
                hashMap = new HashMap(2);
                hashMap.put("name", "\u56de\u6eda\u6b21\u6570");
                hashMap.put("value", (String)((Object)Long.valueOf(((ConnectionStatValue)object2).getRollbackCount())));
                arrayList.add(hashMap);
                hashMap = new HashMap(2);
                hashMap.put("name", "\u5c5e\u6027");
                hashMap.put("value", ((ConnectionStatValue)object2).getProperties().replaceAll(StringUtil.LINE_SEPARATOR, "<br>"));
                arrayList.add(hashMap);
            }
        }
        return arrayList;
    }

    private List getSqlStatDetailList(Properties properties) {
        ArrayList<Map> arrayList = new ArrayList<Map>();
        Map map = jdbcStat.getConnStatMap();
        SqlStat sqlStat = null;
        String string = null;
        String string2 = null;
        if (properties.containsKey(PROP_NAME_SQL_ID)) {
            string = properties.get(PROP_NAME_SQL_ID).toString();
        }
        if (properties.containsKey(PROP_NAME_DATASOURCE_ID)) {
            string2 = properties.get(PROP_NAME_DATASOURCE_ID).toString();
        }
        if (StringUtil.isNotEmpty(string) && StringUtil.isNotEmpty(string2)) {
            block4: for (ConnectionStat connectionStat : map.values()) {
                if (!string2.equals(connectionStat.getId())) continue;
                Map map2 = connectionStat.getSqlStatMap();
                for (SqlStat sqlStat2 : map2.values()) {
                    try {
                        if (!string.equals(sqlStat2.getId())) continue;
                        sqlStat = sqlStat2;
                        break block4;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (sqlStat != null) {
            try {
                arrayList.add(sqlStat.getData());
            }
            catch (JMException jMException) {}
        }
        return arrayList;
    }
}

