/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.OracleDateFormat;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    private static ThreadLocal calendars = new ThreadLocal();

    private static Calendar getCalendar() {
        Calendar calendar = (Calendar)calendars.get();
        if (calendar == null) {
            calendar = Calendar.getInstance();
            calendars.set(calendar);
        }
        return calendar;
    }

    public static byte[] encodeByString(String string, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[8];
        DateUtil.toDT(string, nArray);
        return DateUtil.encode(nArray, n2, n3, n4);
    }

    public static byte[] encodeByDate(Date date, int n2, int n3, Calendar calendar, int n4, int n5) {
        int n6 = 0;
        if (date instanceof Timestamp) {
            n6 = ((Timestamp)date).getNanos();
        }
        int[] nArray = DateUtil.toDT(date.getTime(), n6, calendar);
        return DateUtil.encode(nArray, n2, n3, n4);
    }

    public static byte[] encodeByDateNumber(long l2, int n2, int n3, Calendar calendar, short s2, short s3) {
        byte[] byArray = null;
        switch (n2) {
            case 16: {
                if (l2 > 255611203200L) {
                    DBError.EC_DATETIME_OVERFLOW.throwException(new String[0]);
                }
                int[] nArray = DateUtil.toDT(l2 * 1000L - 2209017600000L, 0L, calendar);
                byArray = DateUtil.encode(nArray, n2, n3, s2);
                break;
            }
            case 15: {
                int[] nArray = DateUtil.toDT(l2 * 1000L, 0L, calendar);
                byArray = DateUtil.encode(nArray, n2, n3, s2);
                break;
            }
            case 14: {
                if (l2 > 2958463L) {
                    DBError.EC_DATETIME_OVERFLOW.throwException(new String[0]);
                }
                int[] nArray = DateUtil.toDT(l2 * 24L * 60L * 60L * 1000L - 2209017600000L, 0L, calendar);
                byArray = DateUtil.encode(nArray, n2, n3, s2);
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
            }
        }
        return byArray;
    }

    public static java.sql.Date toDate(String string, Calendar calendar) {
        int[] nArray = new int[8];
        DateUtil.toDT(string, nArray);
        return new java.sql.Date(DateUtil.toTimeInMillis(nArray, calendar));
    }

    public static Time toTime(String string, Calendar calendar) {
        int[] nArray = new int[8];
        DateUtil.toDT(string, nArray);
        return new Time(DateUtil.toTimeInMillis(nArray, calendar));
    }

    public static Timestamp toTimestamp(String string, Calendar calendar) {
        int[] nArray = new int[8];
        DateUtil.toDT(string, nArray);
        Timestamp timestamp = new Timestamp(DateUtil.toTimeInMillis(nArray, calendar));
        timestamp.setNanos(nArray[6] * 1000);
        return timestamp;
    }

    public static Timestamp toTimestamp(int[] nArray, Calendar calendar) {
        Timestamp timestamp = new Timestamp(DateUtil.toTimeInMillis(nArray, calendar));
        timestamp.setNanos(nArray[6] * 1000);
        return timestamp;
    }

    public static Time toTime(int[] nArray, Calendar calendar) {
        return new Time(DateUtil.toTimeInMillis(nArray, calendar));
    }

    public static java.sql.Date toDate(int[] nArray, Calendar calendar) {
        return new java.sql.Date(DateUtil.toTimeInMillis(nArray, calendar));
    }

    public static int[] decode(byte[] byArray, boolean bl, int n2, int n3, int n4, int n5) {
        int[] nArray = null;
        nArray = bl ? DateUtil.dmdtDecodeBdta(byArray) : DateUtil.dmdtDecodeFast(byArray);
        if (DmdbType.isLocalTimeZone(n2, n3)) {
            DateUtil.transformTZ(nArray, n5, n4);
            n3 = DmdbType.getLocalTimeZoneScale(n2, n3);
        }
        if (n3 > 0 && n3 < 6) {
            int n6 = (int)Math.pow(10.0, 6 - n3);
            nArray[6] = nArray[6] / n6 * n6;
        }
        return nArray;
    }

    private static int[] dmdtDecodeFast(byte[] byArray) {
        int[] nArray = new int[8];
        nArray[7] = Integer.MIN_VALUE;
        if (byArray.length == 3) {
            nArray[0] = ByteUtil.getShort(byArray, 0) & Short.MAX_VALUE;
            if (nArray[0] > 9999) {
                nArray[0] = (short)((short)nArray[0] | 0x8000);
            }
            nArray[1] = (byArray[1] >> 7 & 1) + ((byArray[2] & 7) << 1);
            nArray[2] = (byArray[2] & 0xF8) >> 3 & 0x1F;
        } else if (byArray.length < 8) {
            nArray[3] = (short)(byArray[0] & 0x1F);
            nArray[4] = (short)((byArray[0] >> 5 & 7) + ((byArray[1] & 7) << 3));
            nArray[5] = (short)((byArray[1] >> 3 & 0x1F) + ((byArray[2] & 1) << 5));
            nArray[6] = (byArray[2] >> 1 & 0x7F) + ((byArray[3] & 0xFF) << 7) + ((byArray[4] & 0x1F) << 15);
            if (byArray.length > 5) {
                nArray[7] = ByteUtil.getShort(byArray, 5);
            }
        } else {
            nArray[0] = ByteUtil.getShort(byArray, 0) & Short.MAX_VALUE;
            if (nArray[0] > 9999) {
                nArray[0] = (short)((short)nArray[0] | 0x8000);
            }
            nArray[1] = (byArray[1] >> 7 & 1) + ((byArray[2] & 7) << 1);
            nArray[2] = (byArray[2] & 0xF8) >> 3 & 0x1F;
            nArray[3] = byArray[3] & 0x1F;
            nArray[4] = (byArray[3] >> 5 & 7) + ((byArray[4] & 7) << 3);
            nArray[5] = (byArray[4] >> 3 & 0x1F) + ((byArray[5] & 1) << 5);
            nArray[6] = (byArray[5] >> 1 & 0x7F) + ((byArray[6] & 0xFF) << 7) + ((byArray[7] & 0x1F) << 15);
            if (byArray.length > 8) {
                nArray[7] = ByteUtil.getShort(byArray, 8);
            }
        }
        return nArray;
    }

    private static int[] dmdtDecodeBdta(byte[] byArray) {
        int[] nArray = new int[]{ByteUtil.getShort(byArray, 0), (short)(byArray[2] & 0xFF), (short)(byArray[3] & 0xFF), (short)(byArray[4] & 0xFF), (short)(byArray[5] & 0xFF), (short)(byArray[6] & 0xFF), (byArray[7] & 0xFF) + (byArray[8] << 8) + (byArray[9] << 16), ByteUtil.getShort(byArray, 10)};
        return nArray;
    }

    public static String toString(int[] nArray, String string, int n2) {
        return OracleDateFormat.format(nArray, string, n2);
    }

    public static String toString(int[] nArray, int n2, int n3) {
        switch (n2) {
            case 14: {
                return String.valueOf(DateUtil.formatYear(nArray[0])) + "-" + DateUtil.format2(nArray[1]) + "-" + DateUtil.format2(nArray[2]);
            }
            case 15: {
                if (n3 > 0) {
                    return String.valueOf(DateUtil.format2(nArray[3])) + ":" + DateUtil.format2(nArray[4]) + ":" + DateUtil.format2(nArray[5]) + "." + DateUtil.formatMilliSecond(nArray[6], n3);
                }
                return String.valueOf(DateUtil.format2(nArray[3])) + ":" + DateUtil.format2(nArray[4]) + ":" + DateUtil.format2(nArray[5]);
            }
            case 22: {
                if (n3 > 0) {
                    return String.valueOf(DateUtil.format2(nArray[3])) + ":" + DateUtil.format2(nArray[4]) + ":" + DateUtil.format2(nArray[5]) + "." + DateUtil.formatMilliSecond(nArray[6], n3) + " " + DateUtil.formatTZ(nArray[7]);
                }
                return String.valueOf(DateUtil.format2(nArray[3])) + ":" + DateUtil.format2(nArray[4]) + ":" + DateUtil.format2(nArray[5]) + " " + DateUtil.formatTZ(nArray[7]);
            }
            case 16: {
                if (n3 > 0) {
                    return String.valueOf(DateUtil.formatYear(nArray[0])) + "-" + DateUtil.format2(nArray[1]) + "-" + DateUtil.format2(nArray[2]) + " " + DateUtil.format2(nArray[3]) + ":" + DateUtil.format2(nArray[4]) + ":" + DateUtil.format2(nArray[5]) + "." + DateUtil.formatMilliSecond(nArray[6], n3);
                }
                return String.valueOf(DateUtil.formatYear(nArray[0])) + "-" + DateUtil.format2(nArray[1]) + "-" + DateUtil.format2(nArray[2]) + " " + DateUtil.format2(nArray[3]) + ":" + DateUtil.format2(nArray[4]) + ":" + DateUtil.format2(nArray[5]);
            }
            case 23: {
                if (n3 > 0) {
                    return String.valueOf(DateUtil.formatYear(nArray[0])) + "-" + DateUtil.format2(nArray[1]) + "-" + DateUtil.format2(nArray[2]) + " " + DateUtil.format2(nArray[3]) + ":" + DateUtil.format2(nArray[4]) + ":" + DateUtil.format2(nArray[5]) + "." + DateUtil.formatMilliSecond(nArray[6], n3) + " " + DateUtil.formatTZ(nArray[7]);
                }
                return String.valueOf(DateUtil.formatYear(nArray[0])) + "-" + DateUtil.format2(nArray[1]) + "-" + DateUtil.format2(nArray[2]) + " " + DateUtil.format2(nArray[3]) + ":" + DateUtil.format2(nArray[4]) + ":" + DateUtil.format2(nArray[5]) + " " + DateUtil.formatTZ(nArray[7]);
            }
        }
        return "";
    }

    public static int[] toDT(long l2, long l3, Calendar calendar) {
        if (calendar == null) {
            calendar = DateUtil.getCalendar();
        }
        calendar.setTimeInMillis(l2);
        int[] nArray = new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), (int)(l3 / 1000L), Integer.MIN_VALUE};
        return nArray;
    }

    public static int toDT(String string, int[] nArray) {
        try {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            boolean bl = false;
            int n12 = Integer.MIN_VALUE;
            int n13 = 0;
            String string6 = "000000000";
            if (string == null) {
                DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwException(new String[0]);
            }
            if ((string = string.trim()).startsWith("-", 0)) {
                string = string.substring(1).trim();
                bl = true;
            }
            String[] stringArray = string.split(" ");
            switch (stringArray.length) {
                case 3: {
                    string2 = stringArray[0];
                    string3 = stringArray[1];
                    string5 = stringArray[2];
                    n13 = 23;
                    break;
                }
                case 2: {
                    if (stringArray[0].indexOf(":") > 0) {
                        string3 = stringArray[0];
                        string5 = stringArray[1];
                        n13 = 22;
                        break;
                    }
                    string2 = stringArray[0];
                    string3 = stringArray[1];
                    n13 = 16;
                    break;
                }
                case 1: {
                    if (stringArray[0].indexOf(":") > 0) {
                        string3 = stringArray[0];
                        n13 = 15;
                        break;
                    }
                    string2 = stringArray[0];
                    n13 = 14;
                    break;
                }
                default: {
                    DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwException(new String[0]);
                }
            }
            if (string2 != null) {
                int n14 = string2.indexOf(45);
                int n15 = string2.indexOf(45, n14 + 1);
                if (n14 < 0 || n15 < 0) {
                    n14 = string.indexOf(46);
                    n15 = string.indexOf(46, n14 + 1);
                }
                if (n14 < 0 || n15 < 0) {
                    n14 = string.indexOf(47);
                    n15 = string.indexOf(47, n14 + 1);
                }
                if (n14 > 0 & n15 > 0 & n15 < string2.length() - 1) {
                    n2 = bl ? 0 - Integer.parseInt(string2.substring(0, n14)) - 1900 : Integer.parseInt(string2.substring(0, n14)) - 1900;
                    if (!DateUtil.checkDate(n2 + 1900, (n3 = Integer.parseInt(string2.substring(n14 + 1, n15)) - 1) + 1, n4 = Integer.parseInt(string2.substring(n15 + 1)))) {
                        DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwException(new String[0]);
                    }
                } else {
                    DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwException(new String[0]);
                }
            }
            if (string3 != null) {
                n9 = string3.indexOf(58);
                n10 = string3.indexOf(58, n9 + 1);
                n11 = string3.indexOf(46, n10 + 1);
                if (n9 > 0 & n10 > 0 & n10 < string3.length() - 1) {
                    n5 = Integer.parseInt(string3.substring(0, n9));
                    n6 = Integer.parseInt(string3.substring(n9 + 1, n10));
                    if (n11 > 0 & n11 < string3.length() - 1) {
                        n7 = Integer.parseInt(string3.substring(n10 + 1, n11));
                        string4 = string3.substring(n11 + 1);
                        if (string4.length() > 9) {
                            DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwException(new String[0]);
                        }
                        if (!Character.isDigit(string4.charAt(0))) {
                            DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwException(new String[0]);
                        }
                        string4 = String.valueOf(string4) + string6.substring(0, 9 - string4.length());
                        n8 = Integer.valueOf(string4.substring(0, 6));
                    } else if (n11 > 0) {
                        DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwException(new String[0]);
                    } else {
                        n7 = Integer.parseInt(string3.substring(n10 + 1));
                    }
                    if (n5 > 24 || n5 < 0 || n6 > 60 || n6 < 0 || n7 > 60 || n7 < 0) {
                        DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwException(new String[0]);
                    }
                } else {
                    DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwException(new String[0]);
                }
            }
            if (string5 != null) {
                boolean bl2 = false;
                if (string5.startsWith("-")) {
                    bl2 = true;
                }
                if (string5.startsWith("-") || string5.startsWith("+")) {
                    string5 = string5.substring(1).trim();
                }
                String[] stringArray2 = string5.split(":");
                short s2 = 0;
                int n16 = 0;
                switch (stringArray2.length) {
                    case 2: {
                        s2 = Short.parseShort(stringArray2[0].trim());
                        n16 = Short.parseShort(stringArray2[1].trim());
                        break;
                    }
                    case 1: {
                        s2 = Short.parseShort(stringArray2[0].trim());
                        break;
                    }
                    default: {
                        DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwException(new String[0]);
                    }
                }
                n12 = (short)(s2 * 60 + n16);
                if (n12 < 0) {
                    DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwException(new String[0]);
                }
                if (bl2) {
                    n12 *= -1;
                }
                if (n12 <= -780 || n12 > 840) {
                    DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwException(new String[0]);
                }
            }
            nArray[0] = n2 + 1900;
            nArray[1] = n3 + 1;
            nArray[2] = n4 == 0 ? 1 : n4;
            nArray[3] = n5;
            nArray[4] = n6;
            nArray[5] = n7;
            nArray[6] = n8;
            nArray[7] = n12;
            return n13;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwException(new String[0]);
            return -1;
        }
    }

    public static void transformTZ(int[] nArray, int n2, int n3) {
        int n4 = n2;
        if (nArray[7] != Integer.MIN_VALUE) {
            n4 = nArray[7];
        }
        if (n3 != n4 && (nArray = DateUtil.addMinute(nArray, n3 - n4))[7] != Integer.MIN_VALUE) {
            nArray[7] = n3;
        }
    }

    public static byte[] encode(int[] nArray, int n2, int n3, int n4) {
        if (DmdbType.isLocalTimeZone(n2, n3) && nArray[7] != Integer.MIN_VALUE && nArray[7] != n4) {
            DateUtil.transformTZ(nArray, nArray[7], n4);
        }
        int n5 = nArray[0];
        int n6 = nArray[1];
        int n7 = nArray[2];
        int n8 = nArray[3];
        int n9 = nArray[4];
        int n10 = nArray[5];
        int n11 = nArray[6];
        int n12 = nArray[7] == Integer.MIN_VALUE ? n4 : nArray[7];
        byte[] byArray = null;
        if (n2 == 14) {
            byArray = new byte[]{(byte)(n5 & 0xFF), n5 >= 0 ? (byte)(n5 >> 8 | (n6 & 1) << 7) : (byte)(n5 >> 8 & ((n6 & 1) << 7 | 0x7F)), (byte)((n6 & 0xE) >> 1 | n7 << 3)};
        } else if (n2 == 16) {
            byArray = new byte[]{(byte)(n5 & 0xFF), n5 >= 0 ? (byte)(n5 >> 8 | (n6 & 1) << 7) : (byte)(n5 >> 8 & ((n6 & 1) << 7 | 0x7F)), (byte)((n6 & 0xE) >> 1 | n7 << 3), (byte)(n8 | (n9 & 7) << 5), (byte)((n9 & 0x38) >> 3 | (n10 & 0x1F) << 3), (byte)((n10 & 0x20) >> 5 | (n11 & 0x7F) << 1), (byte)(n11 >> 7 & 0xFF), (byte)(n11 >> 15 & 0xFF)};
        } else if (n2 == 23) {
            byArray = new byte[10];
            byArray[0] = (byte)(n5 & 0xFF);
            byArray[1] = n5 >= 0 ? (byte)(n5 >> 8 | (n6 & 1) << 7) : (byte)(n5 >> 8 & ((n6 & 1) << 7 | 0x7F));
            byArray[2] = (byte)((n6 & 0xE) >> 1 | n7 << 3);
            byArray[3] = (byte)(n8 | (n9 & 7) << 5);
            byArray[4] = (byte)((n9 & 0x38) >> 3 | (n10 & 0x1F) << 3);
            byArray[5] = (byte)((n10 & 0x20) >> 5 | (n11 & 0x7F) << 1);
            byArray[6] = (byte)(n11 >> 7 & 0xFF);
            byArray[7] = (byte)(n11 >> 15 & 0xFF);
            ByteUtil.setShort(byArray, 8, (short)n12);
        } else if (n2 == 15) {
            byArray = new byte[]{(byte)(n8 | (n9 & 7) << 5), (byte)((n9 & 0x38) >> 3 | (n10 & 0x1F) << 3), (byte)((n10 & 0x20) >> 5 | (n11 & 0x7F) << 1), (byte)(n11 >> 7 & 0xFF), (byte)(n11 >> 15 & 0xFF)};
        } else if (n2 == 22) {
            byArray = new byte[7];
            byArray[0] = (byte)(n8 | (n9 & 7) << 5);
            byArray[1] = (byte)((n9 & 0x38) >> 3 | (n10 & 0x1F) << 3);
            byArray[2] = (byte)((n10 & 0x20) >> 5 | (n11 & 0x7F) << 1);
            byArray[3] = (byte)(n11 >> 7 & 0xFF);
            byArray[4] = (byte)(n11 >> 15 & 0xFF);
            ByteUtil.setShort(byArray, 5, (short)n12);
        }
        return byArray;
    }

    public static long toTimeInMillis(int[] nArray, Calendar calendar) {
        if (calendar == null) {
            calendar = DateUtil.getCalendar();
        }
        calendar.set(nArray[0] == 0 ? 1970 : nArray[0], nArray[1] > 0 ? nArray[1] - 1 : 0, nArray[2] == 0 ? 1 : nArray[2], nArray[3], nArray[4], nArray[5]);
        calendar.set(14, 0);
        if (nArray[0] >= 0 && calendar.isSet(0)) {
            calendar.set(0, 1);
        }
        return calendar.getTimeInMillis();
    }

    public static long toTimeInMillis(int[] nArray) {
        return DateUtil.toTimeInMillis(nArray, null);
    }

    private static String formatMilliSecond(int n2, int n3) {
        String string = null;
        string = n2 < 10 ? "00000" + n2 : (n2 < 100 ? "0000" + n2 : (n2 < 1000 ? "000" + n2 : (n2 < 10000 ? "00" + n2 : (n2 < 100000 ? "0" + n2 : Integer.toString(n2)))));
        if (n3 < 6) {
            string = string.substring(0, n3);
        }
        return string;
    }

    private static String formatTZ(int n2) {
        int n3 = Math.abs(n2 / 60);
        int n4 = Math.abs(n2 % 60);
        if (n2 >= 0) {
            return "+" + DateUtil.format2(n3) + ":" + DateUtil.format2(n4);
        }
        return "-" + DateUtil.format2(n3) + ":" + DateUtil.format2(n4);
    }

    private static String formatYear(int n2) {
        if (n2 >= 0) {
            if (n2 < 10) {
                return "000" + n2;
            }
            if (n2 < 100) {
                return "00" + n2;
            }
            if (n2 < 1000) {
                return "0" + n2;
            }
            return Integer.toString(n2);
        }
        if (n2 > -10) {
            return "-000" + -n2;
        }
        if (n2 > -100) {
            return "-00" + -n2;
        }
        if (n2 > -1000) {
            return "-0" + -n2;
        }
        return Integer.toString(n2);
    }

    private static String format2(int n2) {
        if (n2 < 10) {
            return "0" + n2;
        }
        return Integer.toString(n2);
    }

    private static boolean checkDate(int n2, int n3, int n4) {
        if (n2 > 9999 || n3 > 12 || n3 < 1) {
            return false;
        }
        int n5 = DateUtil.getDaysOfMonth(n2, n3);
        return n4 <= n5 && n4 >= 1;
    }

    private static boolean isLeapYear(int n2) {
        return n2 % 4 == 0 && n2 % 100 != 0 || n2 % 400 == 0;
    }

    public static int getDaysOfMonth(int n2, int n3) {
        switch (n3) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                return DateUtil.isLeapYear(n2) ? 29 : 28;
            }
        }
        return 0;
    }

    private static int[] addMinute(int[] nArray, int n2) {
        int n3 = nArray[4] + n2;
        int n4 = n3 / 60;
        if ((n3 %= 60) < 0) {
            n3 += 60;
            --n4;
        }
        nArray[4] = n3;
        DateUtil.addHour(nArray, n4);
        return nArray;
    }

    private static int[] addHour(int[] nArray, int n2) {
        int n3 = nArray[3] + n2;
        int n4 = n3 / 24;
        if ((n3 %= 24) < 0) {
            n3 += 24;
            --n4;
        }
        nArray[3] = n3;
        DateUtil.addDay(nArray, n4);
        return nArray;
    }

    private static int[] addDay(int[] nArray, int n2) {
        int n3 = nArray[2] + n2;
        int n4 = 0;
        while (n3 > (n4 = DateUtil.getDaysOfMonth(nArray[0], nArray[1])) || n3 <= 0) {
            DateUtil.addMonth(nArray, n3 > n4 ? 1 : -1);
            int n5 = n3 = n3 > n4 ? n3 - n4 : n3 + n4;
        }
        nArray[2] = n3;
        return nArray;
    }

    private static int[] addMonth(int[] nArray, int n2) {
        int n3;
        int n4 = nArray[1] + n2;
        int n5 = n4 / 12;
        if ((n4 %= 12) < 1) {
            n4 += 12;
            --n5;
        }
        if (nArray[2] > (n3 = DateUtil.getDaysOfMonth(nArray[0], n4))) {
            nArray[2] = n3;
        }
        nArray[1] = n4;
        DateUtil.addYear(nArray, n5);
        return nArray;
    }

    private static int[] addYear(int[] nArray, int n2) {
        nArray[0] = nArray[0] + n2;
        return nArray;
    }

    public static void main(String[] stringArray) {
        String string = "2018-08-24 10:36:12.987456";
        int[] nArray = new int[8];
        int n2 = DateUtil.toDT(string, nArray);
        DateUtil.addHour(nArray, 14);
        System.out.println(DateUtil.toString(nArray, n2, 6));
    }
}

