/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtil {
    public static final String EMPTY = "";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String LINUX_LINE_SEPARATOR = "\n";
    public static final String INVISIBLE_USERNAME = "\u2026\u2026";
    public static final int yyyy_MM_dd_HH_mm_ss = 2;

    public static String trim(String string) {
        return string == null ? null : string.trim();
    }

    public static String rightTrim(String string) {
        if (string == null) {
            return null;
        }
        return ("r" + string).trim().substring(1);
    }

    public static String trimToEmpty(String string) {
        return string == null ? EMPTY : string.trim();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static String substringBetween(String string, String string2) {
        return StringUtil.substringBetween(string, string2, string2);
    }

    public static String substringBetween(String string, String string2, String string3) {
        int n2;
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        int n3 = string.indexOf(string2);
        if (n3 != -1 && (n2 = string.indexOf(string3, n3 + string2.length())) != -1) {
            return string.substring(n3 + string2.length(), n2);
        }
        return null;
    }

    public static boolean equals(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        return string == null ? string2 == null : string.equalsIgnoreCase(string2);
    }

    public static boolean isDigit(String string) {
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            if (!Character.isDigit(string.charAt(n3))) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean isNumerical(String string) {
        int n2 = 0;
        boolean bl = true;
        if (StringUtil.isEmpty(string = StringUtil.trimToEmpty(string))) {
            return false;
        }
        if (string.startsWith("+") || string.startsWith("-")) {
            if (string.length() == 1) {
                return false;
            }
            n2 = 1;
        }
        int n3 = n2;
        while (n3 < string.length()) {
            if (!Character.isDigit(string.charAt(n3))) {
                if (string.charAt(n3) == '.' && bl) {
                    bl = false;
                } else {
                    return false;
                }
            }
            ++n3;
        }
        return string.length() != n2 + 1 || bl;
    }

    public static boolean isInteger(String string) {
        try {
            Integer.valueOf(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isLong(String string) {
        try {
            Long.valueOf(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isDouble(String string) {
        try {
            Double.valueOf(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String join(Object[] objectArray) {
        return StringUtil.join(objectArray, null);
    }

    public static String join(Object[] objectArray, String string) {
        if (objectArray == null) {
            return null;
        }
        int n2 = objectArray.length;
        int n3 = n2 == 0 ? 0 : ((objectArray[0] == null ? 16 : objectArray[0].toString().length()) + 1) * n2;
        StringBuilder stringBuilder = new StringBuilder(n3);
        int n4 = 0;
        while (n4 < n2) {
            if (n4 > 0) {
                stringBuilder.append(string);
            }
            if (objectArray[n4] != null) {
                stringBuilder.append(objectArray[n4]);
            }
            ++n4;
        }
        return stringBuilder.toString();
    }

    public static String replace(String string, String string2, String string3, int n2) {
        int n3 = n2;
        if (string == null || StringUtil.isEmpty(string2) || string3 == null || n3 == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n4 = 0;
        int n5 = 0;
        while ((n5 = string.indexOf(string2, n4)) != -1) {
            stringBuilder.append(string.substring(n4, n5)).append(string3);
            n4 = n5 + string2.length();
            if (--n3 == 0) break;
        }
        stringBuilder.append(string.substring(n4));
        return stringBuilder.toString();
    }

    public static String replaceAll(String string, String string2, String string3, boolean bl) {
        Pattern pattern = !bl ? Pattern.compile(string2, 2) : Pattern.compile(string2);
        return pattern.matcher(string).replaceAll(string3);
    }

    public static String replaceAllToUpperCase(String string, String string2, boolean bl) {
        Pattern pattern = !bl ? Pattern.compile(string2, 2) : Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (matcher.find()) {
            stringBuffer.append(string.substring(n2, matcher.start()));
            stringBuffer.append(matcher.group().toUpperCase());
            n2 = matcher.end();
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static boolean isValidIP(String string) {
        if ("localhost".equalsIgnoreCase(string)) {
            return true;
        }
        String string2 = "((1[0-9]{1,2}|2([0-4][0-9]|5[0-5])|[0-9\\*]{1,2})\\.(1[0-9]{1,2}|2([0-4][0-9]|5[0-5])|[0-9\\*]{1,2})\\.(1[0-9]{1,2}|2([0-4][0-9]|5[0-5])|[0-9\\*]{1,2})\\.([1][0-9]{1,2}|2([0-4][0-9]|5[0-5])|[0-9\\*]{1,2}))";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        return matcher.find() && matcher.group().length() == string.length();
    }

    public static boolean isValidMac(String string) {
        Pattern pattern = Pattern.compile("([0-9A-Fa-f]{2})(-[0-9A-Fa-f]{2}){5}");
        return pattern.matcher(string).matches();
    }

    public static boolean isValidEmail(String string) {
        Pattern pattern = Pattern.compile("^[A-Z0-9a-z._%+-]+@(([A-Z0-9a-z._]+\\.[A-Za-z]{2,})|(([0-9]{1,3}\\.){3}[0-9]{1,3}))$");
        return pattern.matcher(string).matches();
    }

    public static final String bytesToHexString(byte[] byArray) {
        return StringUtil.bytesToHexString(byArray, false);
    }

    public static final String bytesToHexString(byte[] byArray, boolean bl) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return EMPTY;
        }
        String string = "0123456789ABCDEF";
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        byte[] byArray2 = byArray;
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray2[n3];
            stringBuilder.append(string.charAt(0xF & by >> 4));
            stringBuilder.append(string.charAt(0xF & by));
            ++n3;
        }
        if (bl) {
            return "0x" + stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    public static final byte[] hexStringToBytes(String string) {
        int n2;
        char[] cArray;
        String string2 = string;
        if (string2 == null) {
            return null;
        }
        byte[] byArray = new byte[]{};
        boolean bl = false;
        if ((string2 = string2.trim()).indexOf("0x") == 0 || string2.indexOf("0X") == 0) {
            string2 = string2.substring(2, string2.length());
        }
        if (string2.length() == 0) {
            return byArray;
        }
        char[] cArray2 = string2.toCharArray();
        int n3 = cArray2.length;
        if (n3 % 2 == 0) {
            cArray = cArray2;
        } else {
            cArray = new char[++n3];
            cArray[0] = 48;
            n2 = 0;
            while (n2 < n3 - 1) {
                cArray[n2 + 1] = cArray2[n2];
                ++n2;
            }
        }
        byArray = new byte[n3 / 2];
        int n4 = 0;
        n2 = 0;
        while (n2 < cArray.length) {
            byte by = StringUtil.convertHex(cArray[n2]);
            byte by2 = StringUtil.convertHex(cArray[n2 + 1]);
            if (by == -1 || by2 == -1) {
                bl = true;
                break;
            }
            byArray[n4++] = (byte)(by * 16 + by2);
            n2 += 2;
        }
        if (bl) {
            byArray = string2.getBytes();
        }
        return byArray;
    }

    private static byte convertHex(char c2) {
        byte by;
        if (c2 >= '0' && c2 <= '9') {
            by = (byte)(c2 - 48);
        } else if (c2 >= 'a' && c2 <= 'f') {
            by = (byte)(c2 - 97 + 10);
        } else if (c2 >= 'A' && c2 <= 'F') {
            by = (byte)(c2 - 65 + 10);
        } else {
            return -1;
        }
        return by;
    }

    public static String md5(String string) {
        try {
            byte[] byArray = string.getBytes();
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            return StringUtil.bytesToHexString(byArray2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean startWithIgnoreCase(String string, String string2) {
        return string == null ? string2 == null : string.toUpperCase().startsWith(string2.toUpperCase());
    }

    public static boolean containsIgnoreCase(String string, String string2) {
        return string.toUpperCase().contains(string2.toUpperCase());
    }

    public static String formatCharset(String string, String string2, String string3) {
        String string4 = null;
        if (string2.equalsIgnoreCase("cp850")) {
            string4 = "iso-8859-1";
            return new String(string.getBytes(string4), string3);
        }
        return string;
    }

    public static String formatString(String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder);
        formatter.format(string, objectArray);
        formatter.close();
        return stringBuilder.toString();
    }

    public static int ipToInt(String string) {
        String[] stringArray = string.split("\\.");
        return (Integer.valueOf(stringArray[0]) << 24) + (Integer.valueOf(stringArray[1]) << 16) + (Integer.valueOf(stringArray[2]) << 8) + Integer.valueOf(stringArray[3]);
    }

    public static String intToIp(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n2 >> 24 & 0xFF);
        stringBuilder.append(".");
        stringBuilder.append(n2 >> 16 & 0xFF);
        stringBuilder.append(".");
        stringBuilder.append(n2 >> 8 & 0xFF);
        stringBuilder.append(".");
        stringBuilder.append(n2 & 0xFF);
        return stringBuilder.toString();
    }

    public static String toPersent(double d2) {
        String string = Double.toString(d2 *= 100.0);
        if (string.length() > 6) {
            string = string.substring(0, 6);
        }
        return String.valueOf(string) + "%";
    }

    public static String upperFirstChar(String string) {
        char c2 = string.charAt(0);
        if (c2 > '`' && c2 < '{') {
            char[] cArray = string.toCharArray();
            cArray[0] = (char)(c2 - 32);
            string = new String(cArray);
        }
        return string;
    }

    private static int compareVersion(String string, String string2) {
        string = string.replace("V", EMPTY).replace("v", EMPTY);
        string2 = string2.replace("V", EMPTY).replace("v", EMPTY);
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        if (stringArray.length == 0) {
            return -1;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3;
            if (n2 == stringArray2.length) {
                return 1;
            }
            int n4 = Integer.valueOf(stringArray[n2]);
            if (n4 > (n3 = Integer.valueOf(stringArray2[n2]).intValue())) {
                return 1;
            }
            if (n4 < n3) {
                return -1;
            }
            ++n2;
        }
        if (stringArray.length < stringArray2.length) {
            return -1;
        }
        return 0;
    }

    public static boolean isLastVersion(String string, String string2) {
        return StringUtil.compareVersion(string, string2) >= 0;
    }

    /*
     * Unable to fully structure code
     */
    public static String getAlignNumString(int var0, int var1_1) {
        var2_2 = new StringBuilder();
        if (var0 < var1_1 && var0 >= 0) ** GOTO lbl12
        return String.valueOf(var0);
lbl-1000:
        // 1 sources

        {
            var1_1 /= 10;
            if (var0 >= 1) {
                var2_2.append(var0 % 10);
                var0 /= 10;
                continue;
            }
            var2_2.append("0");
lbl12:
            // 3 sources

            ** while (var1_1 >= 1)
        }
lbl13:
        // 1 sources

        return var2_2.reverse().toString();
    }

    public static boolean isValidTimeZone(String string) {
        int n2;
        int n3;
        char c2;
        block9: {
            String string2;
            block8: {
                if (StringUtil.isEmpty(string)) {
                    return false;
                }
                if (string.length() != 6) {
                    return false;
                }
                c2 = string.charAt(0);
                if (c2 != '+' && c2 != '-') {
                    return false;
                }
                char c3 = string.charAt(3);
                if (c3 != ':') {
                    return false;
                }
                String string3 = string.substring(1, 3);
                string2 = string.substring(4, 6);
                try {
                    n3 = Integer.parseInt(string3);
                    if (n3 >= 0 && n3 <= 14) break block8;
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            n2 = Integer.parseInt(string2);
            if (n2 >= 0 && n2 <= 60) break block9;
            return false;
        }
        int n4 = Integer.parseInt((c2 == '+' ? EMPTY : "-") + (n3 * 60 + n2));
        return n4 <= 840 && n4 >= -779;
    }

    /*
     * Unable to fully structure code
     */
    public static String removeEndSeparatorOfPath(String var0, boolean var1_1) {
        var2_2 = var0.length();
        if (var1_1 && var2_2 == 3) {
            return var0;
        }
        if (var1_1 || var2_2 != 1) ** GOTO lbl8
        return var0;
lbl-1000:
        // 1 sources

        {
            var0 = var0.substring(0, var0.length() - 1);
            var2_2 = var0.length();
lbl8:
            // 2 sources

            ** while (var1_1 && var0.charAt((int)(var2_2 - 1)) == '\\' || var0.charAt((int)(var2_2 - 1)) == '/')
        }
lbl9:
        // 1 sources

        return var0;
    }

    public static String addEndSeparatorOfPath(String string, boolean bl) {
        int n2 = string.length();
        if (bl && string.charAt(n2 - 1) == '\\' || string.charAt(n2 - 1) == '/') {
            return string;
        }
        string = String.valueOf(string) + (bl ? "\\" : "/");
        return string;
    }

    public static String processDoubleQuoteOfName(String string) {
        return StringUtil.processQuoteOfName(string, "\"");
    }

    public static String processDoubleQuoteOfNameForLink(String string) {
        return "\"" + StringUtil.processDoubleQuoteOfName(string) + "\"";
    }

    public static String processSingleQuoteOfName(String string) {
        return StringUtil.processQuoteOfName(string, "'");
    }

    public static String processQuoteOfName(String string, String string2) {
        if (StringUtil.isEmpty(string2) || string == null) {
            return string;
        }
        String string3 = string;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = -1;
        int n3 = string2.length();
        while ((n2 = string3.indexOf(string2)) != -1) {
            stringBuilder.append(string3.substring(0, n2 + n3)).append(string2);
            string3 = string3.substring(n2 + n3);
        }
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    public static String toString(Object object) {
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }

    public static boolean checkPwdComplexity(String string) {
        char[] cArray;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray2 = cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = cArray2[n3];
            if (c2 >= ' ' && c2 <= '~') {
                if (c2 >= '0' && c2 <= '9') {
                    bl = true;
                } else if (c2 >= 'A' && c2 <= 'Z') {
                    bl2 = true;
                } else if (c2 >= 'a' && c2 <= 'z') {
                    bl3 = true;
                } else {
                    bl4 = true;
                }
            }
            if (bl && bl2 && bl3 && bl4) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private static int min(int n2, int n3, int n4) {
        int n5 = n2;
        if (n3 < n5) {
            n5 = n3;
        }
        if (n4 < n5) {
            n5 = n4;
        }
        return n5;
    }

    public static int ld(String string, String string2) {
        int n2 = string.length();
        int n3 = string2.length();
        if (n2 == 0) {
            return n3;
        }
        if (n3 == 0) {
            return n2;
        }
        int[][] nArray = new int[n2 + 1][n3 + 1];
        int n4 = 0;
        while (n4 <= n2) {
            nArray[n4][0] = n4;
            ++n4;
        }
        int n5 = 0;
        while (n5 <= n3) {
            nArray[0][n5] = n5;
            ++n5;
        }
        n4 = 1;
        while (n4 <= n2) {
            char c2 = string.charAt(n4 - 1);
            n5 = 1;
            while (n5 <= n3) {
                char c3 = string2.charAt(n5 - 1);
                int n6 = c2 == c3 ? 0 : 1;
                nArray[n4][n5] = StringUtil.min(nArray[n4 - 1][n5] + 1, nArray[n4][n5 - 1] + 1, nArray[n4 - 1][n5 - 1] + n6);
                ++n5;
            }
            ++n4;
        }
        return nArray[n2][n3];
    }

    public static double sim(String string, String string2) {
        int n2 = StringUtil.ld(string, string2);
        return 1.0 - (double)n2 / (double)Math.max(string.length(), string2.length());
    }

    public static String format2Table(List list, String[] stringArray, String[] stringArray2, int n2, boolean bl) {
        int n3;
        if (list == null || stringArray2 == null) {
            return EMPTY;
        }
        int n4 = 0;
        String string = null;
        int[] nArray = new int[stringArray2.length];
        int n5 = 0;
        while (n5 < stringArray2.length) {
            nArray[n5] = stringArray2[n5].length();
            ++n5;
        }
        for (Map map : list) {
            n3 = 0;
            while (n3 < stringArray2.length) {
                Object v2 = map.get(stringArray2[n3]);
                string = v2 == null ? "null" : v2.toString();
                n4 = string.length();
                if (n4 > nArray[n3]) {
                    nArray[n3] = n4;
                }
                ++n3;
            }
        }
        int n6 = 0;
        while (n6 < stringArray2.length) {
            if (n2 > 0 && nArray[n6] > n2) {
                nArray[n6] = n2;
            }
            ++n6;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray != null) {
            Object object = new HashMap(stringArray.length);
            n3 = 0;
            while (n3 < stringArray.length) {
                object.put(stringArray2[n3], stringArray[n3]);
                ++n3;
            }
            list.add(0, object);
        }
        StringUtil.sepLine(stringBuilder, nArray);
        for (Object object : list) {
            StringUtil.formateLine(stringBuilder, (Map)object, stringArray2, nArray, bl);
            StringUtil.sepLine(stringBuilder, nArray);
        }
        return stringBuilder.toString();
    }

    private static void formateLine(StringBuilder stringBuilder, Map map, String[] stringArray, int[] nArray, boolean bl) {
        boolean bl2 = false;
        int n2 = 0;
        String string = null;
        int n3 = 0;
        while (n3 < stringArray.length) {
            Object v2 = map.get(stringArray[n3]);
            if (v2 == null) {
                string = "null";
            } else {
                string = v2.toString();
                string = string.replace('\t', ' ');
                string = string.replace('\n', ' ');
                string = string.replace('\r', ' ');
            }
            n2 = string.length();
            if (n2 <= nArray[n3]) {
                stringBuilder.append('|');
                stringBuilder.append(string);
                StringUtil.blanks(stringBuilder, nArray[n3] - n2);
                if (bl) {
                    map.put(stringArray[n3], EMPTY);
                }
            } else {
                stringBuilder.append('|');
                if (bl) {
                    stringBuilder.append(string.substring(0, nArray[n3]));
                    map.put(stringArray[n3], string.substring(nArray[n3]));
                    bl2 = true;
                } else {
                    stringBuilder.append(string.substring(0, nArray[n3] - 3)).append("...");
                }
            }
            ++n3;
        }
        stringBuilder.append('|');
        stringBuilder.append('\n');
        if (bl2) {
            StringUtil.formateLine(stringBuilder, map, stringArray, nArray, bl);
        }
    }

    private static void sepLine(StringBuilder stringBuilder, int[] nArray) {
        stringBuilder.append('+');
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            int n5 = 0;
            while (n5 < n4) {
                stringBuilder.append('-');
                ++n5;
            }
            stringBuilder.append('+');
            ++n3;
        }
        stringBuilder.append('\n');
    }

    private static void blanks(StringBuilder stringBuilder, int n2) {
        while (n2 > 0) {
            stringBuilder.append(' ');
            --n2;
        }
    }

    public static long parseDBSvnNumber(String string) {
        long l2 = 0L;
        if (StringUtil.isEmpty(string)) {
            l2 = 0L;
        } else {
            if (string.lastIndexOf("(") < 0 || string.lastIndexOf(")") < 0) {
                return l2;
            }
            if (!(string = string.substring(string.lastIndexOf("(") + 1, string.lastIndexOf(")"))).contains("-")) {
                return l2;
            }
            string = string.substring(string.indexOf("-") + 1, string.length());
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            while (n2 < string.length()) {
                if ('0' > string.charAt(n2) || '9' < string.charAt(n2)) break;
                stringBuilder.append(string.charAt(n2));
                ++n2;
            }
            l2 = Long.valueOf(stringBuilder.toString());
        }
        return l2;
    }

    public static void appendLine(StringBuilder stringBuilder) {
        stringBuilder.append(LINE_SEPARATOR);
    }

    public static long getCurrentSvrNumber(String string) {
        long l2 = 0L;
        if (StringUtil.isNotEmpty(string)) {
            if (string.lastIndexOf("(") < 0 || string.lastIndexOf(")") < 0) {
                return l2;
            }
            if (!(string = string.substring(string.lastIndexOf("(") + 1, string.lastIndexOf(")"))).contains("-")) {
                return l2;
            }
            string = string.substring(string.indexOf("-") + 1, string.length());
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            while (n2 < string.length()) {
                if ('0' > string.charAt(n2) || '9' < string.charAt(n2)) break;
                stringBuilder.append(string.charAt(n2));
                ++n2;
            }
            l2 = Long.valueOf(stringBuilder.toString());
        }
        return l2;
    }

    public static String replaceSpecialCharFromShell(String string) {
        if (StringUtil.isEmpty(string)) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 == '$' || c2 == '\"' || c2 == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c2);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static long getSizeWithoutUnit(String string) {
        if (StringUtil.isLong(string)) {
            return Long.valueOf(string);
        }
        if (string.length() <= 1) {
            return 0L;
        }
        String string2 = string.substring(string.length() - 1);
        String string3 = string.substring(0, string.length() - 1);
        if (string2.equalsIgnoreCase("K")) {
            return Long.parseLong(string3) * 1024L;
        }
        if (string2.equalsIgnoreCase("M")) {
            return Long.parseLong(string3) * 1024L * 1024L;
        }
        if (string2.equalsIgnoreCase("G")) {
            return Long.parseLong(string3) * 1024L * 1024L * 1024L;
        }
        if (string2.equalsIgnoreCase("T")) {
            return Long.parseLong(string3) * 1024L * 1024L * 1024L * 1024L;
        }
        return 0L;
    }

    public static String getSizeWithUnit(long l2) {
        return StringUtil.getSizeWithUnit(l2, EMPTY);
    }

    public static String getSizeWithUnit(long l2, String string) {
        String string2 = EMPTY;
        if (l2 / 1024L > 2L) {
            string2 = String.valueOf(String.valueOf(l2 /= 1024L)) + "K";
            if (string.equalsIgnoreCase("K")) {
                return string2;
            }
        }
        if (l2 / 1024L > 2L) {
            string2 = String.valueOf(String.valueOf(l2 /= 1024L)) + "M";
            if (string.equalsIgnoreCase("M")) {
                return string2;
            }
        }
        if (l2 / 1024L > 2L) {
            string2 = String.valueOf(String.valueOf(l2 /= 1024L)) + "G";
            if (string.equalsIgnoreCase("G")) {
                return string2;
            }
        }
        if (l2 / 1024L > 2L) {
            string2 = String.valueOf(String.valueOf(l2 /= 1024L)) + "T";
            if (string.equalsIgnoreCase("T")) {
                return string2;
            }
        }
        return string2;
    }

    public static List lex(String string, boolean bl, boolean bl2, boolean bl3) {
        return StringUtil.lex(string, bl, bl2, bl3, true);
    }

    public static List lex(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        Stack<Character> stack = new Stack<Character>();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 != '\r' && c2 != '\n') {
                bl9 = false;
            }
            switch (c2) {
                case '\t': 
                case ' ': {
                    if (bl5 || bl6 || bl7 || bl8) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    break;
                }
                case '(': 
                case ')': 
                case '{': 
                case '}': {
                    if (bl5 || bl6 || bl7 || bl8) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    arrayList.add(String.valueOf(c2));
                    break;
                }
                case '.': {
                    if (bl5 || bl6 || bl7 || bl8) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '.') {
                        if (n3 + 2 < n2 && string.charAt(n3 + 2) == '.') {
                            arrayList.add("...");
                            n3 += 2;
                            break;
                        }
                        arrayList.add("..");
                        ++n3;
                        break;
                    }
                    arrayList.add(String.valueOf(c2));
                    break;
                }
                case '!': 
                case '=': 
                case '^': {
                    if (bl5 || bl6 || bl7 || bl8) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '=') {
                        arrayList.add(String.valueOf(c2) + "=");
                        ++n3;
                        break;
                    }
                    arrayList.add(String.valueOf(c2));
                    break;
                }
                case '%': {
                    if (bl5 || bl6 || bl7 || bl8) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '=') {
                        arrayList.add(String.valueOf(c2) + "=");
                        ++n3;
                        break;
                    }
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '%') {
                        arrayList.add("%%");
                        ++n3;
                        break;
                    }
                    arrayList.add(String.valueOf(c2));
                    break;
                }
                case '|': {
                    if (bl5 || bl6 || bl7 || bl8) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '=') {
                        arrayList.add(String.valueOf(c2) + "=");
                        ++n3;
                        break;
                    }
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '|') {
                        arrayList.add("||");
                        ++n3;
                        break;
                    }
                    arrayList.add(String.valueOf(c2));
                    break;
                }
                case '&': {
                    if (bl5 || bl6 || bl7 || bl8) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '=') {
                        arrayList.add(String.valueOf(c2) + "=");
                        ++n3;
                        break;
                    }
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '&') {
                        arrayList.add("&&");
                        ++n3;
                        break;
                    }
                    arrayList.add(String.valueOf(c2));
                    break;
                }
                case '<': {
                    if (bl5 || bl6 || bl7 || bl8) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '=') {
                        arrayList.add(String.valueOf(c2) + "=");
                        ++n3;
                        break;
                    }
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '<') {
                        if (n3 + 2 < n2 && string.charAt(n3 + 2) == '=') {
                            arrayList.add("<<=");
                            n3 += 2;
                            break;
                        }
                        arrayList.add("<<");
                        ++n3;
                        break;
                    }
                    if (string.charAt(n3 + 1) == '>') {
                        arrayList.add(String.valueOf(c2) + ">");
                        ++n3;
                        break;
                    }
                    arrayList.add(String.valueOf(c2));
                    break;
                }
                case '>': {
                    if (bl5 || bl6 || bl7 || bl8) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '=') {
                        arrayList.add(String.valueOf(c2) + "=");
                        ++n3;
                        break;
                    }
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '>') {
                        if (n3 + 2 < n2 && string.charAt(n3 + 2) == '=') {
                            arrayList.add(">>=");
                            n3 += 2;
                            break;
                        }
                        arrayList.add(">>");
                        ++n3;
                        break;
                    }
                    arrayList.add(String.valueOf(c2));
                    break;
                }
                case '+': {
                    if (bl5 || bl6 || bl7 || bl8) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '=') {
                        arrayList.add(String.valueOf(c2) + "=");
                        ++n3;
                        break;
                    }
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '+') {
                        arrayList.add(String.valueOf(c2) + "+");
                        ++n3;
                        break;
                    }
                    arrayList.add(String.valueOf(c2));
                    break;
                }
                case '-': {
                    if (bl5 || bl6 || bl7 || bl8) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '=') {
                        arrayList.add(String.valueOf(c2) + "=");
                        ++n3;
                        break;
                    }
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '-') {
                        if (bl4) {
                            stack.push(Character.valueOf(c2));
                            stack.push(Character.valueOf('-'));
                            bl5 = true;
                            ++n3;
                            break;
                        }
                        arrayList.add(String.valueOf(c2) + "-");
                        ++n3;
                        break;
                    }
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '>') {
                        arrayList.add(String.valueOf(c2) + ">");
                        ++n3;
                        break;
                    }
                    arrayList.add(String.valueOf(c2));
                    break;
                }
                case '*': {
                    if (bl5 || bl6 || bl7 || bl8) {
                        stack.push(Character.valueOf(c2));
                        if (!bl6 || n3 + 1 >= n2 || string.charAt(n3 + 1) != '/') break;
                        stack.push(Character.valueOf('/'));
                        if (!bl2) {
                            StringUtil.decodeWord(stack, arrayList, false);
                        } else {
                            stack.clear();
                        }
                        bl6 = false;
                        ++n3;
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '=') {
                        arrayList.add(String.valueOf(c2) + "=");
                        ++n3;
                        break;
                    }
                    arrayList.add(String.valueOf(c2));
                    break;
                }
                case '/': {
                    if (bl5 || bl6 || bl7 || bl8) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '*') {
                        stack.push(Character.valueOf(c2));
                        stack.push(Character.valueOf('*'));
                        bl6 = true;
                        ++n3;
                        break;
                    }
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '/') {
                        stack.push(Character.valueOf(c2));
                        stack.push(Character.valueOf('/'));
                        bl5 = true;
                        ++n3;
                        break;
                    }
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '=') {
                        arrayList.add(String.valueOf(c2) + "=");
                        ++n3;
                        break;
                    }
                    arrayList.add(String.valueOf(c2));
                    break;
                }
                case '\'': {
                    if (bl5 || bl6 || bl8) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    if (bl7) {
                        if (string.charAt(n3 - 1) == '\\') {
                            stack.push(Character.valueOf(c2));
                            break;
                        }
                        if (n3 + 1 < n2 && string.charAt(n3 + 1) == '\'') {
                            stack.push(Character.valueOf(c2));
                            ++n3;
                            break;
                        }
                        if (bl3) {
                            stack.push(Character.valueOf(c2));
                        }
                        StringUtil.decodeWord(stack, arrayList, true);
                        bl7 = false;
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    if (bl3) {
                        stack.push(Character.valueOf(c2));
                    }
                    bl7 = true;
                    break;
                }
                case '\"': {
                    if (bl5 || bl6 || bl7) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    if (bl8) {
                        if (string.charAt(n3 - 1) == '\\') {
                            stack.push(Character.valueOf(c2));
                            break;
                        }
                        if (n3 + 1 < n2 && string.charAt(n3 + 1) == '\"') {
                            stack.push(Character.valueOf(c2));
                            if (bl3) {
                                stack.push(Character.valueOf(c2));
                            }
                            ++n3;
                            break;
                        }
                        if (bl3) {
                            stack.push(Character.valueOf(c2));
                        }
                        StringUtil.decodeWord(stack, arrayList, true);
                        bl8 = false;
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    if (bl3) {
                        stack.push(Character.valueOf(c2));
                    }
                    bl8 = true;
                    break;
                }
                case '$': {
                    if (bl5 || bl6 || bl7 || bl8) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '$') {
                        arrayList.add("$$");
                        ++n3;
                        break;
                    }
                    if (Character.isDigit(string.charAt(n3 + 1))) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    arrayList.add(String.valueOf(c2));
                    break;
                }
                case '#': {
                    if (bl5 || bl6 || bl7 || bl8) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '#') {
                        arrayList.add("##");
                        ++n3;
                        break;
                    }
                    stack.push(Character.valueOf(c2));
                    break;
                }
                case '\\': {
                    if (bl5 || bl6 || bl7 || bl8) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    arrayList.add(String.valueOf(c2));
                    break;
                }
                case ',': 
                case ';': 
                case '?': {
                    if (bl5 || bl6 || bl7 || bl8) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    arrayList.add(String.valueOf(c2));
                    break;
                }
                case ':': {
                    if (bl5 || bl6 || bl7 || bl8) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    StringUtil.decodeWord(stack, arrayList, false);
                    if (n3 + 1 < n2 && string.charAt(n3 + 1) == '=') {
                        if (bl4) {
                            arrayList.add(":=");
                            ++n3;
                            break;
                        }
                        arrayList.add(String.valueOf(c2));
                        break;
                    }
                    arrayList.add(String.valueOf(c2));
                    break;
                }
                case '\n': 
                case '\r': {
                    if (bl6) {
                        stack.push(Character.valueOf(c2));
                        break;
                    }
                    if (bl5 && bl2) {
                        stack.clear();
                    } else {
                        StringUtil.decodeWord(stack, arrayList, false);
                    }
                    if (!bl && !bl9) {
                        arrayList.add(LINE_SEPARATOR);
                    }
                    bl5 = false;
                    bl9 = true;
                    break;
                }
                default: {
                    stack.push(Character.valueOf(c2));
                }
            }
            ++n3;
        }
        StringUtil.decodeWord(stack, arrayList, false);
        return arrayList;
    }

    private static void decodeWord(Stack stack, List list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(EMPTY);
        while (stack.size() > 0) {
            stringBuilder.insert(0, stack.pop());
        }
        if (bl || stringBuilder.length() > 0) {
            list.add(stringBuilder.toString());
        }
    }

    public static String formatDir(String string) {
        if (StringUtil.isNotEmpty(string = StringUtil.trimToEmpty(string)) && !string.endsWith(File.separator)) {
            string = String.valueOf(string) + File.separator;
        }
        return string;
    }

    public static final String[] split(String string, String string2) {
        int n2;
        if (string == null || string2 == null) {
            return null;
        }
        int[] nArray = new int[string.length()];
        int n3 = 0;
        int n4 = string.length();
        int n5 = string2.length();
        int n6 = 0;
        while (n6 < n4) {
            if (n6 == 0 && n4 >= n5 && string.substring(0, n5).equals(string2)) {
                n6 += n5 - 1;
            } else {
                n2 = 0;
                while (n2 < n5) {
                    if (string.charAt(n6) == string2.charAt(n2)) {
                        nArray[n3] = n6;
                        ++n3;
                        break;
                    }
                    ++n2;
                }
            }
            ++n6;
        }
        String[] stringArray = new String[n3 + 1];
        if (n3 == 0) {
            stringArray[0] = string;
            return stringArray;
        }
        stringArray[0] = string.substring(0, nArray[0]);
        n2 = 1;
        while (n2 < n3) {
            stringArray[n2] = string.substring(nArray[n2 - 1] + 1, nArray[n2]);
            ++n2;
        }
        stringArray[n3] = string.substring(nArray[n3 - 1] + 1, string.length());
        return stringArray;
    }

    public static String formatDateTimeString(Date date, int n2) {
        String string = null;
        int n3 = date.getYear();
        int n4 = date.getMonth();
        String string2 = StringUtil.getStrFromInt(date.getDate());
        String string3 = StringUtil.getStrFromInt(date.getHours());
        String string4 = StringUtil.getStrFromInt(date.getMinutes());
        String string5 = StringUtil.getStrFromInt(date.getSeconds());
        switch (n2) {
            case 2: {
                string = n3 + 1900 + "-" + StringUtil.getStrFromInt(n4 + 1) + "-" + string2 + " " + string3 + ":" + string4 + ":" + string5;
                break;
            }
            default: {
                string = date.toString();
            }
        }
        return string;
    }

    private static String getStrFromInt(int n2) {
        return n2 < 10 ? "0" + n2 : String.valueOf(n2);
    }

    public static void append(StringBuilder stringBuilder, String[] stringArray) {
        StringUtil.append(stringBuilder, stringArray, null);
    }

    public static void append(StringBuilder stringBuilder, String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        if (StringUtil.isEmpty(string)) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringBuilder.append(stringArray[n2]);
                ++n2;
            }
        } else {
            stringBuilder.append(stringArray[0]);
            int n3 = 1;
            while (n3 < stringArray.length) {
                stringBuilder.append(string);
                stringBuilder.append(stringArray[n3]);
                ++n3;
            }
        }
    }

    public static void append(StringBuilder stringBuilder, String string, int n2) {
        StringUtil.append(stringBuilder, string, n2, null);
    }

    public static void append(StringBuilder stringBuilder, String string, int n2, String string2) {
        if (StringUtil.isNotEmpty(string2)) {
            stringBuilder.append(string).append(string2);
            int n3 = 1;
            while (n3 < n2) {
                stringBuilder.append(string2);
                stringBuilder.append(string);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                stringBuilder.append(string);
                ++n4;
            }
        }
    }

    public static String formatTime() {
        return StringUtil.formatDateTimeString(new Timestamp(System.currentTimeMillis()), 2);
    }

    public static String formatTime(String string, String string2) {
        return String.valueOf(string) + StringUtil.formatTime() + string2;
    }

    public static String subString(String string, String string2, String string3) {
        int n2;
        int n3 = string2 == null ? 0 : string.indexOf(string2);
        int n4 = n2 = string3 == null ? string.length() : string.indexOf(string3);
        if (n3 < 0 || n2 < 0 || n3 > n2) {
            return null;
        }
        if (string2 != null) {
            n3 += string2.length();
        }
        return string.substring(n3, n2);
    }

    public static long murmurhash2_64(String string) {
        byte[] byArray = string.getBytes();
        int n2 = byArray.length;
        int n3 = -512093083;
        long l2 = (long)n3 & 0xFFFFFFFFL ^ (long)n2 * -4132994306676758123L;
        int n4 = n2 / 8;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n5 * 8;
            long l3 = ((long)byArray[n6 + 0] & 0xFFL) + (((long)byArray[n6 + 1] & 0xFFL) << 8) + (((long)byArray[n6 + 2] & 0xFFL) << 16) + (((long)byArray[n6 + 3] & 0xFFL) << 24) + (((long)byArray[n6 + 4] & 0xFFL) << 32) + (((long)byArray[n6 + 5] & 0xFFL) << 40) + (((long)byArray[n6 + 6] & 0xFFL) << 48) + (((long)byArray[n6 + 7] & 0xFFL) << 56);
            l3 *= -4132994306676758123L;
            l3 ^= l3 >>> 47;
            l2 ^= (l3 *= -4132994306676758123L);
            l2 *= -4132994306676758123L;
            ++n5;
        }
        switch (n2 % 8) {
            case 7: {
                l2 ^= (long)(byArray[(n2 & 0xFFFFFFF8) + 6] & 0xFF) << 48;
            }
            case 6: {
                l2 ^= (long)(byArray[(n2 & 0xFFFFFFF8) + 5] & 0xFF) << 40;
            }
            case 5: {
                l2 ^= (long)(byArray[(n2 & 0xFFFFFFF8) + 4] & 0xFF) << 32;
            }
            case 4: {
                l2 ^= (long)(byArray[(n2 & 0xFFFFFFF8) + 3] & 0xFF) << 24;
            }
            case 3: {
                l2 ^= (long)(byArray[(n2 & 0xFFFFFFF8) + 2] & 0xFF) << 16;
            }
            case 2: {
                l2 ^= (long)(byArray[(n2 & 0xFFFFFFF8) + 1] & 0xFF) << 8;
            }
            case 1: {
                l2 ^= (long)(byArray[n2 & 0xFFFFFFF8] & 0xFF);
                l2 *= -4132994306676758123L;
            }
        }
        l2 ^= l2 >>> 47;
        l2 *= -4132994306676758123L;
        l2 ^= l2 >>> 47;
        return l2;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void main(String[] stringArray) {
        String string = "call \"(\"(@param_1, @param_2);";
        System.out.print(StringUtil.lex(string, true, true, true));
    }
}

