/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ano;

import java.io.IOException;
import oracle.net.ano.Ano;
import oracle.net.aso.k;
import oracle.net.aso.m;
import oracle.net.ns.DataPacket;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class CryptoDataPacket
extends DataPacket
implements SQLnetDef {
    private m f = null;
    private k g = null;
    private int B = 0;
    private int C = 0;
    private Ano ano = null;

    public CryptoDataPacket(SessionAtts sessionAtts) {
        super(sessionAtts);
        this.ano = sessionAtts.ano;
        if (sessionAtts.ano.f != null) {
            this.f = sessionAtts.ano.f;
            this.C += this.f.z();
        }
        if (sessionAtts.ano.g != null) {
            this.g = sessionAtts.ano.g;
            this.C += this.g.size();
        }
        ++this.C;
    }

    @Override
    protected void createBuffer(int n2) {
        super.createBuffer(n2 + (this.sAtts.poolEnabled ? 16 : 0));
    }

    @Override
    public void receive() {
        super.receive();
        if (this.type != 6) {
            return;
        }
        this.ano = this.sAtts.ano;
        if (this.ano.f != null) {
            this.f = this.ano.f;
            this.C += this.f.z();
            if (this.ano.getRenewKey()) {
                this.f.a(null, null);
            }
        }
        if (this.ano.g != null) {
            this.g = this.ano.g;
            this.C += this.g.size();
            if (this.ano.getRenewKey()) {
                this.g.Z();
            }
        }
        ++this.C;
        this.ano.setRenewKey(false);
        try {
            CryptoDataPacket cryptoDataPacket = this;
            byte[] byArray = new byte[cryptoDataPacket.dataLen - 1];
            byte[] cfr_ignored_0 = cryptoDataPacket.buffer;
            int cfr_ignored_1 = cryptoDataPacket.length;
            --cryptoDataPacket.dataLen;
            System.arraycopy(cryptoDataPacket.buffer, cryptoDataPacket.dataOff, byArray, 0, cryptoDataPacket.dataLen);
            if (cryptoDataPacket.f != null) {
                byArray = cryptoDataPacket.f.f(byArray);
            }
            if (byArray == null) {
                throw new IOException("Bad buffer - Fail to decrypt buffer");
            }
            cryptoDataPacket.dataLen = byArray.length;
            if (cryptoDataPacket.g != null) {
                byte[] byArray2 = new byte[cryptoDataPacket.g.size()];
                cryptoDataPacket.dataLen -= cryptoDataPacket.g.size();
                System.arraycopy(byArray, cryptoDataPacket.dataLen, byArray2, 0, cryptoDataPacket.g.size());
                byte[] byArray3 = new byte[cryptoDataPacket.dataLen];
                System.arraycopy(byArray, 0, byArray3, 0, cryptoDataPacket.dataLen);
                if (cryptoDataPacket.g.c(byArray3, byArray2)) {
                    throw new IOException("Checksum fail");
                }
                System.arraycopy(byArray3, 0, cryptoDataPacket.buffer, cryptoDataPacket.dataOff, cryptoDataPacket.dataLen);
            } else {
                System.arraycopy(byArray, 0, cryptoDataPacket.buffer, cryptoDataPacket.dataOff, cryptoDataPacket.dataLen);
            }
            cryptoDataPacket.length = cryptoDataPacket.dataOff + cryptoDataPacket.dataLen;
            cryptoDataPacket.pktOffset = 10;
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            throw iOException;
        }
    }

    @Override
    protected int putDataInBuffer(byte[] byArray, int n2, int n3) {
        if ((n3 = Math.min(this.buffer.length - this.sessionIdSize - this.C - this.pktOffset, n3)) > 0) {
            System.arraycopy(byArray, n2, this.buffer, this.pktOffset, n3);
            this.pktOffset += n3;
            this.isBufferFull = this.pktOffset + this.C == this.buffer.length - this.sessionIdSize;
            this.availableBytesToSend = this.dataOff < this.pktOffset ? this.pktOffset - this.dataOff : 0;
        }
        return n3;
    }

    @Override
    protected void send(int n2) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        CryptoDataPacket cryptoDataPacket;
        if (this.B < 2) {
            try {
                cryptoDataPacket = this;
                byArray4 = cryptoDataPacket.ano.b();
                byArray3 = cryptoDataPacket.ano.getO3logSessionKey();
                if (byArray3 != null) {
                    byArray2 = new byte[Math.max(byArray3.length, byArray4.length)];
                    byte[] byArray5 = byArray3.length > byArray4.length ? byArray3 : byArray4;
                    System.arraycopy(byArray5, 0, byArray2, 0, byArray5.length);
                    if (byArray3.length < 8 || byArray4.length < 8) {
                        throw new IOException("Key is too small");
                    }
                    for (int i2 = 0; i2 < 8; ++i2) {
                        byArray2[i2] = (byte)(byArray3[i2] ^ byArray4[i2]);
                    }
                    byArray = cryptoDataPacket.ano.a();
                    if (cryptoDataPacket.f != null) {
                        cryptoDataPacket.f.a(byArray2, byArray);
                    }
                    if (cryptoDataPacket.g != null) {
                        cryptoDataPacket.g.d(byArray2, byArray);
                    }
                    cryptoDataPacket.B = 3;
                }
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                throw iOException;
            }
        }
        try {
            cryptoDataPacket = this;
            this.dataLen = cryptoDataPacket.availableBytesToSend;
            if (cryptoDataPacket.dataLen > 0) {
                byArray4 = new byte[cryptoDataPacket.availableBytesToSend];
                System.arraycopy(cryptoDataPacket.buffer, cryptoDataPacket.dataOff, byArray4, 0, byArray4.length);
                byArray3 = null;
                if (cryptoDataPacket.g != null && (byArray3 = cryptoDataPacket.g.e(byArray4, byArray4.length)) != null) {
                    cryptoDataPacket.dataLen += byArray3.length;
                }
                byArray2 = new byte[cryptoDataPacket.dataLen];
                System.arraycopy(byArray4, 0, byArray2, 0, byArray4.length);
                if (byArray3 != null) {
                    System.arraycopy(byArray3, 0, byArray2, byArray4.length, byArray3.length);
                }
                if (cryptoDataPacket.f != null) {
                    byArray = cryptoDataPacket.f.g(byArray2);
                    if (byArray == null) {
                        throw new IOException("Fail to encrypt buffer");
                    }
                    cryptoDataPacket.dataLen = byArray.length;
                    System.arraycopy(byArray, 0, cryptoDataPacket.buffer, cryptoDataPacket.dataOff, cryptoDataPacket.dataLen);
                } else if (cryptoDataPacket.g != null) {
                    System.arraycopy(byArray2, 0, cryptoDataPacket.buffer, cryptoDataPacket.dataOff, cryptoDataPacket.dataLen);
                }
                if (cryptoDataPacket.dataLen > 0) {
                    cryptoDataPacket.buffer[cryptoDataPacket.dataOff + cryptoDataPacket.dataLen] = (byte)(cryptoDataPacket.B >= 2 ? 1 : 0);
                    ++cryptoDataPacket.dataLen;
                }
            }
            cryptoDataPacket.pktOffset = 10 + cryptoDataPacket.dataLen;
            cryptoDataPacket.length = 10 + cryptoDataPacket.dataLen;
        }
        catch (IOException iOException) {
            IOException iOException3 = iOException;
            throw iOException;
        }
        super.send(n2);
    }
}

